<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/container/v1/cluster_service.proto

namespace Google\Cloud\Container\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * ClusterUpdate describes an update to the cluster. Exactly one update can
 * be applied to a cluster with each request, so at most one field can be
 * provided.
 *
 * Generated from protobuf message <code>google.container.v1.ClusterUpdate</code>
 */
class ClusterUpdate extends \Google\Protobuf\Internal\Message
{
    /**
     * The Kubernetes version to change the nodes to (typically an
     * upgrade).
     * Users may specify either explicit versions offered by
     * Kubernetes Engine or version aliases, which have the following behavior:
     * - "latest": picks the highest valid Kubernetes version
     * - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
     * - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
     * - "1.X.Y-gke.N": picks an explicit Kubernetes version
     * - "-": picks the Kubernetes master version
     *
     * Generated from protobuf field <code>string desired_node_version = 4;</code>
     */
    private $desired_node_version = '';
    /**
     * The monitoring service the cluster should use to write metrics.
     * Currently available options:
     * * "monitoring.googleapis.com" - the Google Cloud Monitoring service
     * * "none" - no metrics will be exported from the cluster
     *
     * Generated from protobuf field <code>string desired_monitoring_service = 5;</code>
     */
    private $desired_monitoring_service = '';
    /**
     * Configurations for the various addons available to run in the cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.AddonsConfig desired_addons_config = 6;</code>
     */
    private $desired_addons_config = null;
    /**
     * The node pool to be upgraded. This field is mandatory if
     * "desired_node_version", "desired_image_family" or
     * "desired_node_pool_autoscaling" is specified and there is more than one
     * node pool on the cluster.
     *
     * Generated from protobuf field <code>string desired_node_pool_id = 7;</code>
     */
    private $desired_node_pool_id = '';
    /**
     * The desired image type for the node pool.
     * NOTE: Set the "desired_node_pool" field as well.
     *
     * Generated from protobuf field <code>string desired_image_type = 8;</code>
     */
    private $desired_image_type = '';
    /**
     * Autoscaler configuration for the node pool specified in
     * desired_node_pool_id. If there is only one pool in the
     * cluster and desired_node_pool_id is not provided then
     * the change applies to that single node pool.
     *
     * Generated from protobuf field <code>.google.container.v1.NodePoolAutoscaling desired_node_pool_autoscaling = 9;</code>
     */
    private $desired_node_pool_autoscaling = null;
    /**
     * The desired list of Google Compute Engine
     * [locations](/compute/docs/zones#available) in which the cluster's nodes
     * should be located. Changing the locations a cluster is in will result
     * in nodes being either created or removed from the cluster, depending on
     * whether locations are being added or removed.
     * This list must always include the cluster's primary zone.
     *
     * Generated from protobuf field <code>repeated string desired_locations = 10;</code>
     */
    private $desired_locations;
    /**
     * The desired configuration options for master authorized networks feature.
     *
     * Generated from protobuf field <code>.google.container.v1.MasterAuthorizedNetworksConfig desired_master_authorized_networks_config = 12;</code>
     */
    private $desired_master_authorized_networks_config = null;
    /**
     * The Kubernetes version to change the master to.
     * Users may specify either explicit versions offered by
     * Kubernetes Engine or version aliases, which have the following behavior:
     * - "latest": picks the highest valid Kubernetes version
     * - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
     * - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
     * - "1.X.Y-gke.N": picks an explicit Kubernetes version
     * - "-": picks the default Kubernetes version
     *
     * Generated from protobuf field <code>string desired_master_version = 100;</code>
     */
    private $desired_master_version = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $desired_node_version
     *           The Kubernetes version to change the nodes to (typically an
     *           upgrade).
     *           Users may specify either explicit versions offered by
     *           Kubernetes Engine or version aliases, which have the following behavior:
     *           - "latest": picks the highest valid Kubernetes version
     *           - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
     *           - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
     *           - "1.X.Y-gke.N": picks an explicit Kubernetes version
     *           - "-": picks the Kubernetes master version
     *     @type string $desired_monitoring_service
     *           The monitoring service the cluster should use to write metrics.
     *           Currently available options:
     *           * "monitoring.googleapis.com" - the Google Cloud Monitoring service
     *           * "none" - no metrics will be exported from the cluster
     *     @type \Google\Cloud\Container\V1\AddonsConfig $desired_addons_config
     *           Configurations for the various addons available to run in the cluster.
     *     @type string $desired_node_pool_id
     *           The node pool to be upgraded. This field is mandatory if
     *           "desired_node_version", "desired_image_family" or
     *           "desired_node_pool_autoscaling" is specified and there is more than one
     *           node pool on the cluster.
     *     @type string $desired_image_type
     *           The desired image type for the node pool.
     *           NOTE: Set the "desired_node_pool" field as well.
     *     @type \Google\Cloud\Container\V1\NodePoolAutoscaling $desired_node_pool_autoscaling
     *           Autoscaler configuration for the node pool specified in
     *           desired_node_pool_id. If there is only one pool in the
     *           cluster and desired_node_pool_id is not provided then
     *           the change applies to that single node pool.
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $desired_locations
     *           The desired list of Google Compute Engine
     *           [locations](/compute/docs/zones#available) in which the cluster's nodes
     *           should be located. Changing the locations a cluster is in will result
     *           in nodes being either created or removed from the cluster, depending on
     *           whether locations are being added or removed.
     *           This list must always include the cluster's primary zone.
     *     @type \Google\Cloud\Container\V1\MasterAuthorizedNetworksConfig $desired_master_authorized_networks_config
     *           The desired configuration options for master authorized networks feature.
     *     @type string $desired_master_version
     *           The Kubernetes version to change the master to.
     *           Users may specify either explicit versions offered by
     *           Kubernetes Engine or version aliases, which have the following behavior:
     *           - "latest": picks the highest valid Kubernetes version
     *           - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
     *           - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
     *           - "1.X.Y-gke.N": picks an explicit Kubernetes version
     *           - "-": picks the default Kubernetes version
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Container\V1\ClusterService::initOnce();
        parent::__construct($data);
    }

    /**
     * The Kubernetes version to change the nodes to (typically an
     * upgrade).
     * Users may specify either explicit versions offered by
     * Kubernetes Engine or version aliases, which have the following behavior:
     * - "latest": picks the highest valid Kubernetes version
     * - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
     * - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
     * - "1.X.Y-gke.N": picks an explicit Kubernetes version
     * - "-": picks the Kubernetes master version
     *
     * Generated from protobuf field <code>string desired_node_version = 4;</code>
     * @return string
     */
    public function getDesiredNodeVersion()
    {
        return $this->desired_node_version;
    }

    /**
     * The Kubernetes version to change the nodes to (typically an
     * upgrade).
     * Users may specify either explicit versions offered by
     * Kubernetes Engine or version aliases, which have the following behavior:
     * - "latest": picks the highest valid Kubernetes version
     * - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
     * - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
     * - "1.X.Y-gke.N": picks an explicit Kubernetes version
     * - "-": picks the Kubernetes master version
     *
     * Generated from protobuf field <code>string desired_node_version = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setDesiredNodeVersion($var)
    {
        GPBUtil::checkString($var, True);
        $this->desired_node_version = $var;

        return $this;
    }

    /**
     * The monitoring service the cluster should use to write metrics.
     * Currently available options:
     * * "monitoring.googleapis.com" - the Google Cloud Monitoring service
     * * "none" - no metrics will be exported from the cluster
     *
     * Generated from protobuf field <code>string desired_monitoring_service = 5;</code>
     * @return string
     */
    public function getDesiredMonitoringService()
    {
        return $this->desired_monitoring_service;
    }

    /**
     * The monitoring service the cluster should use to write metrics.
     * Currently available options:
     * * "monitoring.googleapis.com" - the Google Cloud Monitoring service
     * * "none" - no metrics will be exported from the cluster
     *
     * Generated from protobuf field <code>string desired_monitoring_service = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setDesiredMonitoringService($var)
    {
        GPBUtil::checkString($var, True);
        $this->desired_monitoring_service = $var;

        return $this;
    }

    /**
     * Configurations for the various addons available to run in the cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.AddonsConfig desired_addons_config = 6;</code>
     * @return \Google\Cloud\Container\V1\AddonsConfig
     */
    public function getDesiredAddonsConfig()
    {
        return $this->desired_addons_config;
    }

    /**
     * Configurations for the various addons available to run in the cluster.
     *
     * Generated from protobuf field <code>.google.container.v1.AddonsConfig desired_addons_config = 6;</code>
     * @param \Google\Cloud\Container\V1\AddonsConfig $var
     * @return $this
     */
    public function setDesiredAddonsConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\AddonsConfig::class);
        $this->desired_addons_config = $var;

        return $this;
    }

    /**
     * The node pool to be upgraded. This field is mandatory if
     * "desired_node_version", "desired_image_family" or
     * "desired_node_pool_autoscaling" is specified and there is more than one
     * node pool on the cluster.
     *
     * Generated from protobuf field <code>string desired_node_pool_id = 7;</code>
     * @return string
     */
    public function getDesiredNodePoolId()
    {
        return $this->desired_node_pool_id;
    }

    /**
     * The node pool to be upgraded. This field is mandatory if
     * "desired_node_version", "desired_image_family" or
     * "desired_node_pool_autoscaling" is specified and there is more than one
     * node pool on the cluster.
     *
     * Generated from protobuf field <code>string desired_node_pool_id = 7;</code>
     * @param string $var
     * @return $this
     */
    public function setDesiredNodePoolId($var)
    {
        GPBUtil::checkString($var, True);
        $this->desired_node_pool_id = $var;

        return $this;
    }

    /**
     * The desired image type for the node pool.
     * NOTE: Set the "desired_node_pool" field as well.
     *
     * Generated from protobuf field <code>string desired_image_type = 8;</code>
     * @return string
     */
    public function getDesiredImageType()
    {
        return $this->desired_image_type;
    }

    /**
     * The desired image type for the node pool.
     * NOTE: Set the "desired_node_pool" field as well.
     *
     * Generated from protobuf field <code>string desired_image_type = 8;</code>
     * @param string $var
     * @return $this
     */
    public function setDesiredImageType($var)
    {
        GPBUtil::checkString($var, True);
        $this->desired_image_type = $var;

        return $this;
    }

    /**
     * Autoscaler configuration for the node pool specified in
     * desired_node_pool_id. If there is only one pool in the
     * cluster and desired_node_pool_id is not provided then
     * the change applies to that single node pool.
     *
     * Generated from protobuf field <code>.google.container.v1.NodePoolAutoscaling desired_node_pool_autoscaling = 9;</code>
     * @return \Google\Cloud\Container\V1\NodePoolAutoscaling
     */
    public function getDesiredNodePoolAutoscaling()
    {
        return $this->desired_node_pool_autoscaling;
    }

    /**
     * Autoscaler configuration for the node pool specified in
     * desired_node_pool_id. If there is only one pool in the
     * cluster and desired_node_pool_id is not provided then
     * the change applies to that single node pool.
     *
     * Generated from protobuf field <code>.google.container.v1.NodePoolAutoscaling desired_node_pool_autoscaling = 9;</code>
     * @param \Google\Cloud\Container\V1\NodePoolAutoscaling $var
     * @return $this
     */
    public function setDesiredNodePoolAutoscaling($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\NodePoolAutoscaling::class);
        $this->desired_node_pool_autoscaling = $var;

        return $this;
    }

    /**
     * The desired list of Google Compute Engine
     * [locations](/compute/docs/zones#available) in which the cluster's nodes
     * should be located. Changing the locations a cluster is in will result
     * in nodes being either created or removed from the cluster, depending on
     * whether locations are being added or removed.
     * This list must always include the cluster's primary zone.
     *
     * Generated from protobuf field <code>repeated string desired_locations = 10;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getDesiredLocations()
    {
        return $this->desired_locations;
    }

    /**
     * The desired list of Google Compute Engine
     * [locations](/compute/docs/zones#available) in which the cluster's nodes
     * should be located. Changing the locations a cluster is in will result
     * in nodes being either created or removed from the cluster, depending on
     * whether locations are being added or removed.
     * This list must always include the cluster's primary zone.
     *
     * Generated from protobuf field <code>repeated string desired_locations = 10;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setDesiredLocations($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->desired_locations = $arr;

        return $this;
    }

    /**
     * The desired configuration options for master authorized networks feature.
     *
     * Generated from protobuf field <code>.google.container.v1.MasterAuthorizedNetworksConfig desired_master_authorized_networks_config = 12;</code>
     * @return \Google\Cloud\Container\V1\MasterAuthorizedNetworksConfig
     */
    public function getDesiredMasterAuthorizedNetworksConfig()
    {
        return $this->desired_master_authorized_networks_config;
    }

    /**
     * The desired configuration options for master authorized networks feature.
     *
     * Generated from protobuf field <code>.google.container.v1.MasterAuthorizedNetworksConfig desired_master_authorized_networks_config = 12;</code>
     * @param \Google\Cloud\Container\V1\MasterAuthorizedNetworksConfig $var
     * @return $this
     */
    public function setDesiredMasterAuthorizedNetworksConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Container\V1\MasterAuthorizedNetworksConfig::class);
        $this->desired_master_authorized_networks_config = $var;

        return $this;
    }

    /**
     * The Kubernetes version to change the master to.
     * Users may specify either explicit versions offered by
     * Kubernetes Engine or version aliases, which have the following behavior:
     * - "latest": picks the highest valid Kubernetes version
     * - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
     * - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
     * - "1.X.Y-gke.N": picks an explicit Kubernetes version
     * - "-": picks the default Kubernetes version
     *
     * Generated from protobuf field <code>string desired_master_version = 100;</code>
     * @return string
     */
    public function getDesiredMasterVersion()
    {
        return $this->desired_master_version;
    }

    /**
     * The Kubernetes version to change the master to.
     * Users may specify either explicit versions offered by
     * Kubernetes Engine or version aliases, which have the following behavior:
     * - "latest": picks the highest valid Kubernetes version
     * - "1.X": picks the highest valid patch+gke.N patch in the 1.X version
     * - "1.X.Y": picks the highest valid gke.N patch in the 1.X.Y version
     * - "1.X.Y-gke.N": picks an explicit Kubernetes version
     * - "-": picks the default Kubernetes version
     *
     * Generated from protobuf field <code>string desired_master_version = 100;</code>
     * @param string $var
     * @return $this
     */
    public function setDesiredMasterVersion($var)
    {
        GPBUtil::checkString($var, True);
        $this->desired_master_version = $var;

        return $this;
    }

}

