<?php
include("config.php");
if (!loggedin()) {
    header("Location: login.php");
    exit();
}if (($_SESSION['about'] != '1')) {
    header("Location: error.php");
    exit();
}
?>
<!DOCTYPE html>
<html>
    <?php include("include/heads.php"); ?>	
    <body class="fixed-left">
        <div id="wrapper">
            <!-- Top Bar Start -->
            <?php include("include/topbar.php"); ?>
            <!-- Top Bar End -->

            <!-- Left Sidebar Start -->
            <?php include("include/leftsidebar.php"); ?>
            <!-- Left Sidebar End -->

            <!-- Start right Content here -->

            <!-- ============================================================== -->
            <!-- Start right Content here -->
            <!-- ============================================================== -->  		

            <?php
            if (isset($_POST['submit'])) {

                $userName = mysqli_real_escape_string($con, trim($_POST['userName']));
                $userjob = mysqli_real_escape_string($con, trim($_POST['job']));
                $date_added = date("Y-m-d");

                $photo_name = $_FILES['image']['name'];
                $photo_tmp = $_FILES['image']['tmp_name'];
                $allowed_ext = array('jpg', 'jpeg', 'gif', 'png');
                $get_image_ext = explode('.', $photo_name);
                $image_ext = strtolower(end($get_image_ext));

                $errors = array();

                if (empty($userName)) {
                    $errors[] = "من فضلك ادخل جميع الحقول !";
                } else {
                    if (in_array($image_ext, $allowed_ext) === false) {
                        echo get_error("هذا الملف غير مسموح به !");
                    }
                }
                if (!empty($errors)) {
                    foreach ($errors as $error) {
                        //echo $error, '<br />';
                        echo get_error($error);
                    }
                } else {
                    $image_path = "api/uploads/staff/" . $photo_name;
                    $image_database = "{$sit_url}/api/uploads/staff/" . $photo_name;

                    $add_staff = add_staff($userName, $userjob, $image_database, $date_added);
                    $id = mysqli_insert_id($con);
                    if (!file_exists("api/uploads/staff/" . $id)) {
                        mkdir("api/uploads/staff/" . $id, 0777, true);
                    }
                    $image_path = "api/uploads/staff/" . mysqli_insert_id($con) . "/" . $photo_name;
                    $image_database = "{$sit_url}/api/uploads/staff/" . mysqli_insert_id($con) . "/" . $photo_name;

                    $update = $con->query("UPDATE `staff` SET 
`image`='$image_database' WHERE `id`='" . mysqli_insert_id($con) . "'");

                    if (move_uploaded_file($photo_tmp, $image_path)) {

                        $thumb = new easyphpthumbnail;

                        $thumb->Thumbsize = 150;

                        $thumb->Createthumb($image_path, 'file');

                        // to Prevent Duplicate The Same Image (We Will Delete The Image In The Folder That Contain Class)


                        $same_path = dirname(__FILE__) . "/" . $photo_name;

                        if (copy($same_path, $photo_tmp)) {
                            unlink($same_path);
                        }
                    }
                    echo get_success("تم الإضافة بنجاح");
                }
            }
            ?>	

            <?php // if(isset($_POST['submit'])) { echo add_user(); }  ?>

            <div class="content-page">
                <!-- Start content -->
                <div class="content">
                    <div class="container">

                        <!-- Page-Title -->
                        <div class="row">
                            <div class="col-sm-12">
                                <h4 class="page-title">فريق العمل</h4>
                                <ol class="breadcrumb">
                                    <li><a href="staff_view.php">فريق العمل</a></li>
                                    <li class="active">أضف عامل جديد</li>
                                </ol>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-lg-12">
                                <div class="card-box">
                                    <h4 class="m-t-0 header-title"><b>أضف عامل جديد</b></h4>
                                    <p class="text-muted font-13 m-b-30">
                                        أضف  عامل جديد ضمن  فريق عمل الحاليين.
                                    </p>

                                    <form method="POST" action="<?php echo $_SERVER['PHP_SELF']; ?>" enctype="multipart/form-data" data-parsley-validate novalidate>
                                        <div class="form-group">
                                            <label for="userName">الإسم*</label>
                                            <input type="text" name="userName" parsley-trigger="change" required placeholder="الإسم" class="form-control" id="userName">
                                        </div>
                                        <div class="form-group">
                                            <label for="emailAddress">الوظيفة*</label>
                                            <input type="job" name="job" parsley-trigger="change" required placeholder="الوظيفة" class="form-control" id="job">
                                        </div>

                                        <div class="form-group m-b-0">
                                            <label class="control-label">الصورة الشخصية</label>
                                            <input type="file" name="image" id="photo" class="filestyle" data-buttonname="btn-primary">
                                        </div>										
                                        <br>

                                        <div class="form-group text-right m-b-0">
                                            <button class="btn btn-primary waves-effect waves-light" type="submit" name="submit">
                                                إضافة
                                            </button>
                                            <button type="reset" class="btn btn-default waves-effect waves-light m-l-5">
                                                إلغاء
                                            </button>
                                        </div>

                                    </form>

                                </div>
                            </div>
                        </div>			
                    </div>			
                </div>
                <?php include("include/footer_text.php"); ?>

            </div>			

            <!-- End Right content here -->

            <!-- Right Sidebar -->
            <div class="side-bar right-bar nicescroll">
                <?php include("include/rightbar.php"); ?>
            </div>
            <!-- /Right-bar -->
        </div>
        <!-- END wrapper -->
        <?php include("include/footer.php"); ?>

        <script>
            $(document).ready(function () {
                $("#cssmenu ul>li").removeClass("active");
                $("#item9").addClass("active");
            });
        </script>

    </body>
</html>