<?php
include("config.php");
if (!loggedin()) {
    header("Location: login.php");
    exit();
}if (($_SESSION['salon_type'] != '1')) {
    header("Location: error.php");
    exit();
}
?>
<!DOCTYPE html>
<html>
    <?php include("include/heads.php"); ?>
    <body class="fixed-left">
        <div id="wrapper">
            <!-- Top Bar Start -->
            <?php include("include/topbar.php"); ?>
            <!-- Top Bar End -->

            <!-- Left Sidebar Start -->
            <?php include("include/leftsidebar.php"); ?>
            <!-- Left Sidebar End -->

            <!-- Start right Content here -->

            <?php
            if (isset($_POST['submit'])) {

                $salon_name_ar = mysqli_real_escape_string($con, trim($_POST['salon_name_ar']));
                $salon_name_en = mysqli_real_escape_string($con, trim($_POST['salon_name_en']));

                $errors = array();
                if (!empty($errors)) {
                    foreach ($errors as $error) {
                        echo get_error($error);
                    }
                } else {
                    $add_FAQ = add_salon_type($salon_name_ar,$salon_name_en);
                    if($add_FAQ){
                        echo get_success("تم الإضافة بنجاح");
                    }else{
                        echo get_error(mysqli_error($con));
                    }
              }
            }
            ?>

            <div class="content-page">
                <!-- Start content -->
                <div class="content">
                    <div class="container">
                        <!-- Page-Title -->
                        <div class="row">
                            <div class="col-sm-12">
                                <h4 class="page-title">أنواع الصالونات</h4>
                                <ol class="breadcrumb">
                                    <li><a href="salon_type_view.php"></a> أنواع الصالونات</li>
                                    <li class="active">أضف نوع جديد</li>
                                </ol>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="card-box">
                                    <h4 class="m-t-0 header-title"><b>أضف نوع جديد</b></h4>
                                    <p class="text-muted font-13 m-b-30">أضف نوع جديد</p>
                                    <form method="POST" action="<?php echo $_SERVER['PHP_SELF']; ?>" enctype="multipart/form-data" data-parsley-validate novalidate>

                                        <div class="form-group col-m-6">
                                            <label for="userName"> الأسم عربي *</label>
                                            <input type="text" name="salon_name_ar" parsley-trigger="change" required placeholder="الأسم عربي" class="form-control" id="FAQ_code">
                                        </div>

                                        <div class="form-group col-m-6">
                                            <label for="userName"> الأسم انجليزي*</label>
                                            <input type="text" name="salon_name_en" parsley-trigger="change" required placeholder="اﻷسم أنجليزي" class="form-control" id="FAQ_code">
                                          </div>
                                        <br />

                                        <div class="form-group text-right m-b-0">
                                            <button class="btn btn-primary waves-effect waves-light" type="submit" name="submit"> إضافة </button>
                                            <button type="reset" class="btn btn-default waves-effect waves-light m-l-5"> إلغاء </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
              <?php include('include/footer_text.php'); ?>
            </div>

            <!-- End Right content here -->

            <!-- Right Sidebar -->
            <div class="side-bar right-bar nicescroll">
                <?php include("include/rightbar.php"); ?>
            </div>
            <!-- /Right-bar -->
        </div>
        <!-- END wrapper -->
        <?php include("include/footer.php"); ?>

        <script>
            $(document).ready(function () {
                $("#cssmenu ul>li").removeClass("active");
                $("#item500").addClass("active");
            });
        </script>

    </body>
</html>
