<?php
include("config.php");
if (!loggedin()) {
    header("Loserviceion: login.php");
    exit();
}
if(($_SESSION['salon_service'] != '1')) {
    header("Loserviceion: error.php");
    exit();
}
//
// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);
?>
<!DOCTYPE html>
<html>
    <?php include("include/heads.php"); ?>
    <body class="fixed-left">
        <div id="wrapper">
            <!-- Top Bar Start -->
            <?php include("include/topbar.php"); ?>
            <!-- Top Bar End -->

            <!-- Left Sidebar Start -->
            <?php include("include/leftsidebar.php"); ?>
            <!-- Left Sidebar End -->

            <!-- Start right Content here -->

            <?php
            if (isset($_POST['submit'])){

                $parent_service_id = mysqli_real_escape_string($con, trim($_POST['parent_service_id']));
                $sub_service_id = mysqli_real_escape_string($con, trim($_POST['sub_service_id']))?$_POST['sub_service_id']:0;
                $salon_id=$_POST['salon_id'];
                $cost=mysqli_real_escape_string($con, trim($_POST['cost']));

                $errors = array();
                if (!empty($errors)) {
                    foreach ($errors as $error) {
                        echo get_error($error);
                    }

                }else{

                    $check_salon_service=check_salon_service($parent_service_id,$sub_service_id, $salon_id,$cost);

                    if($check_salon_service){
                      //exists before
                     echo get_error("هذا الأسم مسجل من قبل");
                    }else{
                      $add_salon_service = add_salon_service($parent_service_id,$sub_service_id, $salon_id,$cost);
                      if($add_salon_service){
                          echo get_success("تم الإضافة بنجاح");
                      }else{
                          echo get_error("لم يتم الأضافه");
                      }
                    }
                }

                  echo "<meta http-equiv='refresh' content='0'>";

            }

            ?>

            <div class="content-page">
                <!-- Start content -->
                <div class="content">
                    <div class="container">
                        <!-- Page-Title -->
                        <div class="row">
                            <div class="col-sm-12">
                                <h4 class="page-title"> خدمات الصالون</h4>
                                <ol class="breadcrumb">
                                    <li><a href="salon_service_view.php"> خدمات الصالون</a></li>
                                    <li class="active">أضف خدمة لصالون</li>
                                </ol>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="card-box">
                                    <h4 class="m-t-0 header-title"><b>أضف خدمة جديد لصالون</b></h4>
                                    <p class="text-muted font-13 m-b-30">أضف خدمة  لصالون.</p>
                                    <form method="POST" action="<?php echo $_SERVER['PHP_SELF']; ?>" enctype="multipart/form-data" data-parsley-validate novalidate>

                                        <div class="form-group col-md-3">
                                            <label class="control-label">الخدمة الرئيسية</label>
                                            <select class="form-control" name="parent_service_id" id="parent_service_id" parsley-trigger="change">
                                              <?php
                                                  $query=$con->query("SELECT * FROM `parent_services` WHERE `type`=1 ");
                                                  $select="";
                                                  while ($row=mysqli_fetch_assoc($query)) {
                                                    $id=$row['id'];
                                                    $name=$row['name'];
                                                   $select.="<option value='{$id}'>{$name}</option>";
                                                  }
                                                  echo $select;


                                               ?>
                                            </select>
                                        </div>

                                        <div class="form-group col-md-3">
                                            <label class="control-label">الخدمة الفرعية</label>
                                            <select class="form-control" name="sub_service_id" id="sub_service_id"  parsley-trigger="change">
                                            </select>
                                        </div>


                                        <div class="form-group col-md-3">
                                            <label class="control-label"> الصالون</label>
                                            <select class="form-control" name="salon_id" id="salon_id"  parsley-trigger="change">
                                              <?php
                                                  $query=$con->query("SELECT  `id`,`name` FROM `salons`  ");
                                                  $select="";
                                                  while ($row=mysqli_fetch_assoc($query)) {
                                                    $id=$row['id'];
                                                    $name=$row['name'];
                                                   $select.="<option value='{$id}'>{$name}</option>";
                                                  }
                                                  echo $select;


                                               ?>
                                            </select>
                                        </div>

                                        <div class="form-group col-md-3">
                                            <label for="time">تكلفة الخدمة</label>
                                            <input type="number" name="cost" parsley-trigger="change"  placeholder="تكلفة الخدمة" class="form-control" id="time">
                                        </div>

                                        <div class="form-group text-right m-b-0">
                                            <button class="btn btn-primary waves-effect waves-light" type="submit" name="submit"> إضافة </button>
                                            <button type="reset" class="btn btn-default waves-effect waves-light m-l-5"> إلغاء </button>
                                        </div>

                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                    <?php include("include/footer_text.php"); ?>

                </div>

                <!-- End Right content here -->

                <!-- Right Sidebar -->
                <div class="side-bar right-bar nicescroll">
                    <?php include("include/rightbar.php"); ?>
                </div>
                <!-- /Right-bar -->
            </div>
        </div>
    </div>
    <!-- END wrapper -->
    <?php include("include/footer.php"); ?>

    <script>
      // on change
      $("#parent_service_id").change(function () {
        // alert("sss");
          var parent_service_id = $(this).val();
          var dataString = 'parent_service_id=' + parent_service_id;
           //alert(get_region_id);
          $.ajax({
              type: "POST",
              url: "functions/salon_service_functions.php",
              data: dataString,
              dataType: 'text',
              cache: false,
              success: function (html) {
                $("#sub_service_id option").remove();
                $("#sub_service_id").removeAttr('disabled');
                $("#sub_service_id").append(html);
              },error: function(html) {
                  alert(html);
              }
          });

      });



        $(document).ready(function () {
          var parent_service_id = $('#parent_service_id').val();
          var dataString = 'parent_service_id=' + parent_service_id;
           //alert(get_region_id);
          $.ajax({
              type: "POST",
              url: "functions/salon_service_functions.php",
              data: dataString,
              dataType: 'text',
              cache: false,
              success: function (html) {
                $("#sub_service_id option").remove();
                $("#sub_service_id").removeAttr('disabled');
                $("#sub_service_id").append(html);
              },error: function(html) {
                  alert(html);
              }
          });



            $("#cssmenu ul>li").removeClass("active");
            $("#item2").addClass("active");
        });
    </script>

</body>
</html>
