<?php
include("config.php");
if (!loggedin()) {
    header("Location: login.php");
    exit();
}if (($_SESSION['reservations'] != '1')) {
    header("Location: error.php");
    exit();
}
?>
<!DOCTYPE html>
<html>
    <?php include("include/heads.php"); ?>
    <link href="assets/plugins/datatables/datatables.min.css" rel="stylesheet" type="text/css" />
    <link href="assets/plugins/datatables/plugins/bootstrap/datatables.bootstrap-rtl.css" rel="stylesheet" type="text/css" />

    <body class="fixed-left">
        <div id="wrapper">
            <!-- Top Bar Start -->
            <?php include("include/topbar.php"); ?>
            <!-- Top Bar End -->

            <!-- Left Sidebar Start -->
            <?php include("include/leftsidebar.php"); ?>
            <!-- Left Sidebar End -->

            <!-- Start right Content here -->

            <div class="deleteData"></div>

            <div class="content-page">
                <!-- Start content -->
                <div class="content">
                    <div class="container">

                        <!-- Page-Title -->
                        <div class="row">
                            <div class="col-sm-12">
                                <h4 class="page-title">مشاهدة الحجوزات</h4>
                                <ol class="breadcrumb">
                                    <li><a href="regions_view.php">الحجوزات</a></li>
                                    <li class="active">مشاهدة الحجوزات</li>
                                </ol>
                            </div>
                        </div>



                        <div class="panel">
                            <div class="panel-body">
                                <div class="">
                                    <table class="table table-striped" id="custom_tbl_dt">
                                        <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>الشركة</th>
                                                <th>الماركة</th>
                                                <th>السيارة</th>
                                                <th>اسم العميل</th>
                                                <th> رقم الهاتف</th>
                                                <th>الإيميل</th>
                                                <th>تفاصيل الحجز</th>
                                                <th>الإجمالي</th>
                                                <th>من</th>
                                                <th>الى</th>
                                                  <th>التاريخ</th>
                                                <th>موافقه</th>
                                                <th>رفض</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                          <?php echo view_reservations(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
                <?php include("include/footer_text.php"); ?>

            </div>
            <!-- MODAL -->
            <div id="dialog" class="modal-block mfp-hide">
                <section class="panel panel-info panel-color">
                    <header class="panel-heading">
                        <h2 class="panel-title">هل انت متأكد؟</h2>
                    </header>
                    <div class="panel-body">
                        <div class="modal-wrapper">
                            <div class="modal-text">
                                <p>هل تريد حذف هذا العنصر؟</p>
                            </div>
                        </div>
                        <div class="row m-t-20">
                            <div class="col-md-12 text-right">
                                <button id="dialogConfirm" class="btn btn-primary waves-effect waves-light">تأكيد</button>
                                <button id="dialogCancel" class="btn btn-default waves-effect">إلغاء</button>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
            <!-- end Modal -->

            <!-- End Right content here -->

            <!-- Right Sidebar -->
            <div class="side-bar right-bar nicescroll">
                <?php include("include/rightbar.php"); ?>
            </div>
            <!-- /Right-bar -->
        </div>
        <!-- END wrapper -->
        <?php include("include/footer.php"); ?>
        <script src="assets/plugins/datatables/datatables.min.js" type="text/javascript"></script>
        <script src="assets/plugins/datatables/plugins/bootstrap/datatables.bootstrap.js"></script>

        <script type="text/javascript">
        $('body').on('click', '.approve', function () {
            var reservation_id_approve = $(this).attr('id');
            var dataString = 'reservation_id_approve=' + reservation_id_approve;
            bootbox.dialog({
                message: "هل تريد تأكيد الحجز ؟",
                title: " رسالة تأكيد الحجز",
                buttons: {
                    danger: {
                        label: "الغاء",
                        className: "btn-danger"
                    },
                    main: {
                        label: "تأكيد",
                        className: "btn-primary",
                        callback: function () {
                            //do something else
                            $.ajax({
                                type: "POST",
                                url: "functions/reservations_function.php",
                                data: dataString,
                                dataType: 'text',
                                cache: false,
                                success: function (data) {
                                      $(".deleteData").html(data);
                                      var class_id='row_'+reservation_id_approve;
                                       $('#'+class_id).remove();
                                }
                            });
                        }
                    }
                }
            });
        });


        $('body').on('click', '.cancel', function () {
            var reservation_id_cancel = $(this).attr('id');
            var dataString = 'reservation_id_cancel=' + reservation_id_cancel;
            bootbox.dialog({
                message: "هل تريد الغاء الحجز ؟",
                title: " رسالة الغاء الحجز",
                buttons: {
                    danger: {
                        label: "الغاء",
                        className: "btn-danger"
                    },
                    main: {
                        label: "تأكيد",
                        className: "btn-primary",
                        callback: function () {
                            //do something else
                            $.ajax({
                                type: "POST",
                                url: "functions/reservations_function.php",
                                data: dataString,
                                dataType: 'text',
                                cache: false,
                                success: function (data) {
                                      $(".deleteData").html(data);
                                      var class_id='row_'+reservation_id_cancel;
                                      $('#'+class_id).remove();
                                }
                            });
                        }
                    }
                }
            });
        });




            // $('body').on('click', '.approve', function () {
            //     var reservation_id_approve = $(this).attr('id');
            //
            //
            //     $("#dialogConfirm").click(function () {
            //         var dataString = 'reservation_id_approve=' + reservation_id_approve;
            //         $.ajax({
            //             type: "POST",
            //             url: "functions/reservations_function.php",
            //             data: dataString,
            //             dataType: 'text',
            //             cache: false,
            //             success: function (data) {
            //                 $(".deleteData").html(data);
            //                 alert(data);
            //             }
            //         });
            //     });
            // });
        </script>





        <script type="text/javascript">
            //to open model for accept del
            $('body').on('click', '.deletemsg', function () {
                var region_delete = $(this).attr('data-id');
                var dataString = 'region_delete=' + region_delete;
                var urlgo = $(this).attr('data-link');
                bootbox.dialog({
                    message: "هل تريد حذف هذا العنصر؟",
                    title: "رساله تاكيد الحذف",
                    buttons: {
                        danger: {
                            label: "الغاء",
                            className: "btn-danger"
                        },
                        main: {
                            label: "حذف",
                            className: "btn-primary",
                            callback: function () {
                                //do something else
                                $.ajax({
                                    type: "POST",
                                    url: urlgo,
                                    data: dataString,
                                    dataType: 'text',
                                    cache: false,
                                    success: function (data) {
                                        $(".deleteData").html(data);
                                        $("." + region_delete).remove();

                                        //alert(category);
                                    }
                                });
                            }
                        }
                    }
                });
            });

            $('body').on('change', '.change_region_status_off', function () {
                var change_region_status_off = $(this).attr('data-id');
                var dataString = 'change_region_status_off=' + change_region_status_off;
                swal({
                    title: "تأكيد الإخفاء  ؟",
                    text: "",
                    type: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#DD6B55",
                    confirmButtonText: "نـــعــم",
                    cancelButtonText: "إلغاء",
                    closeOnConfirm: false,
                    closeOnCancel: true
                }, function (isConfirm) {
                    if (isConfirm) {
                        swal("تم التغيير", "", "success");
                        var dataString = 'change_region_status_off=' + change_region_status_off;
                        $.ajax({
                            type: "POST",
                            url: "functions/regions_functions.php",
                            data: dataString,
                            dataType: 'text',
                            cache: false,
                            success: function (data) {
                                $(".deleteData").html(data);
                            }
                        });
                    } else {
                        swal("تم التغيير", "تم التغيير :)", "error");
                    }
                });
            });
            $('body').on('change', '.change_region_status_on', function () {
                var change_region_status_on = $(this).attr('data-id');
                var dataString = 'change_region_status_on=' + change_region_status_on;
                swal({
                    title: "تغيير الحالة ؟",
                    text: "",
                    type: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#DD6B55",
                    confirmButtonText: "نـــعــم",
                    cancelButtonText: "إلغاء",
                    closeOnConfirm: false,
                    closeOnCancel: true
                }, function (isConfirm) {
                    if (isConfirm) {
                        swal("تم التغيير", "", "success");
                        var dataString = 'change_region_status_on=' + change_region_status_on;
                        $.ajax({
                            type: "POST",
                            url: "functions/regions_functions.php",
                            data: dataString,
                            dataType: 'text',
                            cache: false,
                            success: function (data) {
                                $(".deleteData").html(data);
                            }
                        });
                    } else {
                        swal("تم التغيير", "تم التغيير :)", "error");
                    }
                });
            });
            $('body').on('change', '.change_setting_status_off', function () {
                var change_setting_status_off = $(this).attr('data-id');
                swal({
                    title: "تأكيد الإخفاء  ؟",
                    text: "",
                    type: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#DD6B55",
                    confirmButtonText: "نـــعــم",
                    cancelButtonText: "إلغاء",
                    closeOnConfirm: false,
                    closeOnCancel: true
                }, function (isConfirm) {
                    if (isConfirm) {
                        swal("تم التغيير", "", "success");
                        var dataString = 'change_setting_status_off=' + change_setting_status_off;
                        $.ajax({
                            type: "POST",
                            url: "functions/regions_functions.php",
                            data: dataString,
                            dataType: 'text',
                            cache: false,
                            success: function (data) {
                                $(".deleteData").html(data);
                            }
                        });
                    } else {
                        swal("تم التغيير", "تم التغيير :)", "error");
                    }
                });
            });
            $('body').on('change', '.change_setting_status_on', function () {
                var change_setting_status_on = $(this).attr('data-id');
                swal({
                    title: "تغيير الحالة ؟",
                    text: "",
                    type: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#DD6B55",
                    confirmButtonText: "نـــعــم",
                    cancelButtonText: "إلغاء",
                    closeOnConfirm: false,
                    closeOnCancel: true
                }, function (isConfirm) {
                    if (isConfirm) {
                        swal("تم التغيير", "", "success");
                        var dataString = 'change_setting_status_on=' + change_setting_status_on;
                        $.ajax({
                            type: "POST",
                            url: "functions/regions_functions.php",
                            data: dataString,
                            dataType: 'text',
                            cache: false,
                            success: function (data) {
                                $(".deleteData").html(data);
                            }
                        });
                    } else {
                        swal("تم التغيير", "تم التغيير :)", "error");
                    }
                });
            });
        </script>

        <script>
            $(document).ready(function () {
                $("#cssmenu ul>li").removeClass("active");
                $("#item6").addClass("active");
            });
        </script>

    </body>
</html>
