<?php
include("config.php");
if (!loggedin()) {
    header("Location: login.php");
    exit();
 }
if (($_SESSION['categories'] != '1')) {
    header("Location: error.php");
    exit();
}
?>
<!DOCTYPE html>
<html>
    <?php include("include/heads.php"); ?>
     <link href="assets/plugins/datatables/datatables.min.css" rel="stylesheet" type="text/css" />
    <link href="assets/plugins/datatables/plugins/bootstrap/datatables.bootstrap-rtl.css" rel="stylesheet" type="text/css" />
    <body class="fixed-left">
        <div id="wrapper">
            <!-- Top Bar Start -->
            <?php include("include/topbar.php"); ?>
            <!-- Top Bar End -->

            <!-- Left Sidebar Start -->
            <?php include("include/leftsidebar.php"); ?>
            <!-- Left Sidebar End -->

            <!-- Start right Content here -->

            <div class="deleteData"></div>

            <div class="content-page">
                <!-- Start content -->
                <div class="content">
                    <div class="container">

                        <!-- Page-Title -->
                        <div class="row">
                            <div class="col-sm-12">
                                <h4 class="page-title">مشاهدة  الفئات</h4>
                                <ol class="breadcrumb">
                                    <li><a href="category_view.php">الفئات </a></li>
                                    <li class="active">مشاهدة الفئات </li>
                                </ol>
                            </div>
                        </div>

                        <div class="panel">
                            <div class="panel-body">
                                <div class="">
                                    <table class="table table-striped" id="custom_tbl_dt">
                                        <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>الأسم</th>
                                                <th>الأسم بالأنجليزي</th>
                                                <th>الصورة</th>
                                                <th></th>
                                            </tr>
                                        </thead>
                                        <tbody> <?php echo view_category(); ?> </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
                <?php include("include/footer_text.php"); ?>
         </div>


            <!-- MODAL -->
            <!-- MODAL -->
            <div id="dialog" class="modal-block mfp-hide">
                <section class="panel panel-info panel-color">
                    <header class="panel-heading">
                        <h2 class="panel-title">هل انت متأكد؟</h2>
                    </header>
                    <div class="panel-body">
                        <div class="modal-wrapper">
                            <div class="modal-text">
                                <p>هل تريد حذف هذا العنصر ؟</p>
                            </div>
                        </div>
                        <div class="row m-t-20">
                            <div class="col-md-12 text-right">
                                <button id="dialogConfirm" class="btn btn-primary waves-effect waves-light">تأكيد</button>
                                <button id="dialogCancel" class="btn btn-default waves-effect">إلغاء</button>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
            <!-- end Modal -->

            <!-- End Right content here -->

            <!-- Right Sidebar -->
            <div class="side-bar right-bar nicescroll">
                <?php include("include/rightbar.php"); ?>
            </div>
            <!-- /Right-bar -->
        </div>
        <!-- END wrapper -->
        <?php include("include/footer.php"); ?>
           <script src="assets/plugins/datatables/datatables.min.js" type="text/javascript"></script>
        <script src="assets/plugins/datatables/plugins/bootstrap/datatables.bootstrap.js"></script>

        

        <script type="text/javascript">
            $(document).ready(function () {
                $('body').on('click', '.deletemsg', function () {
                    var category_delete = $(this).attr('data-id');
                    var dataString = 'category_delete=' + category_delete;
                    bootbox.dialog({
                        message: "هل تريد حذف هذا العنصر؟",
                        title: "رساله تاكيد الحذف", buttons: {
                            danger: {
                                label: "الغاء",
                                className: "btn-danger"
                            },
                            main: {
                                label: "حذف", className: "btn-primary",
                                callback: function () {
                                    //do something else
                                    $.ajax({
                                        type: "POST",
                                        url: "functions/category_functions.php",
                                        data: dataString,
                                        dataType: 'text', cache: false,
                                        success: function (data) {
                                            $(".deleteData").html(data);
                                            $("." + model_delete).remove();

                                            //alert(category);
                                        }
                                    });
                                }
                            }
                        }
                    });
                });

            });
        </script>

        <script>
            $(document).ready(function () {
                $("#cssmenu ul>li").removeClass("active");
                $("#item103").addClass("active");
            });
        </script>

    </body>
</html>
