<?php
include("config.php");
if (!loggedin()) {
    header("Location: login.php");
    exit();
}if (($_SESSION['FAQ'] != '1')) {
    header("Location: error.php");
    exit();
}
?>
<!DOCTYPE html>
<html>
    <?php include("include/heads.php"); ?>
    <body class="fixed-left">
        <div id="wrapper">
            <!-- Top Bar Start -->
            <?php include("include/topbar.php"); ?>
            <!-- Top Bar End -->

            <!-- Left Sidebar Start -->
            <?php include("include/leftsidebar.php"); ?>
            <!-- Left Sidebar End -->

            <!-- Start right Content here -->

            <?php
            if (isset($_POST['submit'])) {

                $FAQ_question_ar = mysqli_real_escape_string($con, trim($_POST['FAQ_question_ar']));
                $FAQ_answer_ar = mysqli_real_escape_string($con, trim($_POST['FAQ_answer_ar']));
                $FAQ_question_en = mysqli_real_escape_string($con, trim($_POST['FAQ_question_en']));
                $FAQ_answer_en = mysqli_real_escape_string($con, trim($_POST['FAQ_answer_en']));

                $errors = array();

                if (!empty($errors)) {
                    foreach ($errors as $error) {
                        //echo $error, '<br />';
                        echo get_error($error);
                    }
                } else {
                    $add_FAQ = add_FAQ($FAQ_question_ar,$FAQ_answer_ar,$FAQ_question_en,$FAQ_answer_en);
                    if($add_FAQ){
                        echo get_success("تم الإضافة بنجاح");
                    }else{
                        echo get_error(mysqli_error($con));
                    }
              }
            }
            ?>

            <div class="content-page">
                <!-- Start content -->
                <div class="content">
                    <div class="container">
                        <!-- Page-Title -->
                        <div class="row">
                            <div class="col-sm-12">
                                <h4 class="page-title">الأسئلة</h4>
                                <ol class="breadcrumb">
                                    <li><a href="client_view.php">الأسئلة</a></li>
                                    <li class="active">أضف سؤال جديد</li>
                                </ol>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="card-box">
                                    <h4 class="m-t-0 header-title"><b>أضف سؤال جديد</b></h4>
                                    <p class="text-muted font-13 m-b-30">أضف سؤال جديد ضمن الأسئلة</p>
                                    <form method="POST" action="<?php echo $_SERVER['PHP_SELF']; ?>" enctype="multipart/form-data" data-parsley-validate novalidate>
                                        <div class="form-group col-m-6">
                                            <label for="userName"> السؤال عربي *</label>
                                            <input type="text" name="FAQ_question_ar" parsley-trigger="change" required placeholder=" السؤال عربي" class="form-control" id="FAQ_code">
                                        </div>
                                        <div class="form-group col-m-6">
                                            <label for="userName"> الأجابة عربي*</label>
                                            <textarea cols="100" rows="5" name="FAQ_answer_ar" parsley-trigger="change" required placeholder="الأجابه بالعربي"></textarea>
                                        </div>

                                        <div class="form-group col-m-6">
                                            <label for="userName"> السؤال أنجليزي *</label>
                                            <input type="text" name="FAQ_question_en" parsley-trigger="change" required placeholder=" السؤال أنجليزي" class="form-control" id="FAQ_code">
                                        </div>
                                        <div class="form-group col-m-6">
                                            <label for="userName"> الأجابة أنجليزي*</label>
                                              <textarea  cols="100" rows="5"  name="FAQ_answer_en" parsley-trigger="change" required placeholder="الأجابه بالأنجليزي"></textarea>
                                        </div>



                                        <br />

                                        <div class="form-group text-right m-b-0">
                                            <button class="btn btn-primary waves-effect waves-light" type="submit" name="submit"> إضافة </button>
                                            <button type="reset" class="btn btn-default waves-effect waves-light m-l-5"> إلغاء </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
              <?php include('include/footer_text.php'); ?>
            </div>

            <!-- End Right content here -->

            <!-- Right Sidebar -->
            <div class="side-bar right-bar nicescroll">
                <?php include("include/rightbar.php"); ?>
            </div>
            <!-- /Right-bar -->
        </div>
        <!-- END wrapper -->
        <?php include("include/footer.php"); ?>

        <script>
            $(document).ready(function () {
                $("#cssmenu ul>li").removeClass("active");
                $("#item500").addClass("active");
            });
        </script>

    </body>
</html>
