<?php
include("config.php");
if (!loggedin()) {
    header("Location: login.php");
    exit();
}if (0) {
    header("Location: error.php");
    exit();
}
?>
<!DOCTYPE html>
<html>
    <?php include("include/heads.php"); ?>
    <body class="fixed-left">
        <div id="wrapper">
            <!-- Top Bar Start -->
            <?php include("include/topbar.php"); ?>
            <!-- Top Bar End -->

            <!-- Left Sidebar Start -->
            <?php include("include/leftsidebar.php"); ?>
            <!-- Left Sidebar End -->

            <!-- Start right Content here -->

            <?php
            if (isset($_POST['submit'])) {

                $copoun_code = mysqli_real_escape_string($con, trim($_POST['copoun_code']));
                $copoun_date_from = mysqli_real_escape_string($con, trim($_POST['copoun_date_from']));
                $copoun_date_to = mysqli_real_escape_string($con, trim($_POST['copoun_date_to']));
                $copoun_type = mysqli_real_escape_string($con, trim($_POST['copoun_type']))?:2;
                $copoun_value = mysqli_real_escape_string($con, trim($_POST['copoun_value']));

                $errors = array();
                if(strtotime($copoun_date_from) > strtotime($copoun_date_to) ){
                    
                     $errors[]="يجب أن يكون تاريخ البدايه قبل تاريخ النهاية ";
                    
                }
                

                if (!empty($errors)) {
                    foreach ($errors as $error) {
                        //echo $error, '<br />';
                        echo get_error($error);
                    }
                } else {
                    $add_copoun = add_copoun($copoun_code, $copoun_date_from, $copoun_date_to, $copoun_type,$copoun_value);
                    if($add_copoun){
                        echo get_success("تم الإضافة بنجاح");
                    }else{
                        echo get_error(mysqli_error($con));
                    }
              }
            }
            ?>

            <div class="content-page">
                <!-- Start content -->
                <div class="content">
                    <div class="container">
                        <!-- Page-Title -->
                        <div class="row">
                            <div class="col-sm-12">
                                <h4 class="page-title">البرومو كود</h4>
                                <ol class="breadcrumb">
                                    <li><a href="client_view.php">البرومو كود</a></li>
                                    <li class="active">أضف برومو كود جديد</li>
                                </ol>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="card-box">
                                    <h4 class="m-t-0 header-title"><b>أضف برومو كود جديد</b></h4>
                                    <p class="text-muted font-13 m-b-30">أضف برومو كود جديد ضمن البرومو كود</p>
                                    <form method="POST" action="<?php echo $_SERVER['PHP_SELF']; ?>" enctype="multipart/form-data" data-parsley-validate novalidate>
                                        <div class="form-group">
                                            <label for="userName"> كود  البرومو كود*</label>
                                            <input type="text" name="copoun_code" parsley-trigger="change" required placeholder="كود الكوبون" class="form-control" id="copoun_code">
                                        </div>
                                        <div class="form-group">
                                            <label for="userName">من تاريخ*</label>
                                            <input type="date" name="copoun_date_from" parsley-trigger="change" required placeholder="من تاريخ" class="form-control" id="copoun_date_from">
                                        </div>
                                        <div class="form-group">
                                            <label for="email">الى تاريخ*</label>
                                            <input type="date" name="copoun_date_to" parsley-trigger="change" required placeholder="الى تاريخ" class="form-control" id="copoun_date_to">
                                        </div>
                                        
                                        <!--<div class="form-group">-->
                                        <!--    <label for="userName"> النوع*</label>-->
                                        <!--     <select class="form-control  select2me" required id="copoun_type" name="copoun_type">-->
                                        <!--      <option value='0'> اختر</option>-->
                                        <!--      <option value='1'> نسبة مئوية </option>-->
                                        <!--      <option value='2'> قيمة </option>-->
                                        <!--</div>-->

                                          <div class="form-group">
                                            <label for="userName"> القيمه*</label>
                                            <input type="number" step="0.5" name="copoun_value" parsley-trigger="change" required placeholder="القيمة" class="form-control" id="copoun_value">
                                        </div>
                                        <br />

                                        <div class="form-group text-right m-b-0">
                                            <button class="btn btn-primary waves-effect waves-light" type="submit" name="submit"> إضافة </button>
                                            <button type="reset" class="btn btn-default waves-effect waves-light m-l-5"> إلغاء </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php include("include/footer_text.php"); ?>
            </div>

            <!-- End Right content here -->

            <!-- Right Sidebar -->
            <div class="side-bar right-bar nicescroll">
                <?php include("include/rightbar.php"); ?>
            </div>
            <!-- /Right-bar -->
        </div>
        <!-- END wrapper -->
        <?php include("include/footer.php"); ?>

        <script>
            $(document).ready(function () {
                $("#cssmenu ul>li").removeClass("active");
                $("#item666").addClass("active");
            });
        </script>

    </body>
</html>
