<?php

/*
 * Following code will list all the products
 */
// array for JSON response
$response = array();

// include db connect class
include("db_connect.php");

// connecting to db
$con = new DB_CONNECT();
$connection=$con->connect();

$connection->query("SET NAMES 'utf8'");

$connection->query("SET CHARACTER SET utf8");

$connection->query("SET SESSION collation_connection = 'utf8_unicode_ci'");

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET,POST,PUT,DELETE,OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');
$required_parametrs=array(

                          '1'=>  'lang',
                          '2'=>  'client_id',
                          '3'=>  'car_id',
                          '4'=>  'price',
                          '5'=>  'price_per_day',
                          '6'=>  'driver',
                          '7'=>  'driver_additional',
                          '8'=>  'recieved_another_place',
                          '9'=>  'detials',
                          '10'=> 'total_cost',
                          '11'=> 'date_from',
                          '12'=> 'date_to',
                          '13'=> 'number_of_days'
                        );
$errors=array();
foreach ($_POST as $key => $value) {
   if(in_array($key,$required_parametrs)){
     $key = array_search($key, $required_parametrs);
     unset($required_parametrs[$key]);

   }else{
     $errors[]="Parameter field is required:";
   }
}


if(count($required_parametrs)>0){
  //some parameters required
  $response["success"] = 0;
  if ($lang == "ar") {
      $response["message"] = "هناك بيانات مفقوده برجاء مراجعة بياناتك";
  } else {
      $response["message"] = $errors[0];
  }

}else{
  //data required is set

  $lang=mysqli_real_escape_string($connection, trim($_POST['lang']));
  $client_id=mysqli_real_escape_string($connection, trim($_POST['client_id']));
  $car_id=mysqli_real_escape_string($connection, trim($_POST['car_id']));
  $price=mysqli_real_escape_string($connection, trim($_POST['price']));
  $price_per_day=mysqli_real_escape_string($connection, trim($_POST['price_per_day']));
  $driver=mysqli_real_escape_string($connection, trim($_POST['driver']));
  $driver_additional=mysqli_real_escape_string($connection, trim($_POST['driver_additional']));
  $recieved_another_place=mysqli_real_escape_string($connection, trim($_POST['recieved_another_place']));
  $detials=mysqli_real_escape_string($connection, trim($_POST['detials']));
  $total_cost=mysqli_real_escape_string($connection, trim($_POST['total_cost']));
  $date_from=mysqli_real_escape_string($connection, trim($_POST['date_from']));
  $date_to=mysqli_real_escape_string($connection, trim($_POST['date_to']));
  $number_of_days=mysqli_real_escape_string($connection, trim($_POST['number_of_days']));

 $add_reservation=add_reservation($client_id,$car_id,$price,$price_per_day,$driver,
                                  $driver_additional,$recieved_another_place,
                                  $detials,$total_cost,$date_from,$date_to,
                                  $number_of_days
                                );

  // // check for empty result
  if ($add_reservation) {
             $response["success"] = 1;
             if ($lang == "ar") {
                   $response["message"] ="تم الحجز";
             } else {
                   $response["message"] = "reserved successfully";
             }

  }else{
          // sent
         $response["success"] = 0;
         if ($lang == "ar") {
               $response["message"] ="هناك خطأ في الأدخال";
         }else{
               $response["message"] = "reservation error insert";
         }

      }


}
  echo json_encode($response);
?>
