<?php

/*
 * Following code will list all the products
 */
// array for JSON response
$response = array();

// include db connect class
include("db_connect.php");

// connecting to db
$con = new DB_CONNECT();
$connection=$con->connect();

$connection->query("SET NAMES 'utf8'");

$connection->query("SET CHARACTER SET utf8");

$connection->query("SET SESSION collation_connection = 'utf8_unicode_ci'");

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET,POST,PUT,DELETE,OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

$required_parametrs=array("lang","mandoob_id","date_from","date_to");


$errors=array();

$postdata = file_get_contents("php://input");
$Req = json_decode($postdata, TRUE);


foreach ($Req as $key => $value) {
   if(in_array($key,$required_parametrs)){
     $key = array_search($key, $required_parametrs);
     unset($required_parametrs[$key]);

   }else{
     $errors[]="Parameter field is required:";
   }
}
$lang=$Req['lang'];

if(count($required_parametrs)>0){
  //some parameters required
  $response["success"] = 0;
  if ($lang == "ar") {
      $response["message"] = "هناك بيانات مفقوده برجاء مراجعة بياناتك";
  } else {
      $response["message"] = "error in Your Inputs";
  }
  
    $response["required_parametrs"]=$required_parametrs;

}else{

    $lang=mysqli_real_escape_string($connection, trim($Req['lang']));
    
    $mandoob_id=mysqli_real_escape_string($connection, trim($Req['mandoob_id']));
  
    $date_from=mysqli_real_escape_string($connection, trim($Req['date_from']));
    
    $date_to=mysqli_real_escape_string($connection, trim($Req['date_to']));
    
    
    $response["success"] = 1;
    
    //get orders by date from and to 
    
    $orders=get_orders_filter($mandoob_id,$date_from,$date_to);
    
    $response["orders"] =$orders;
      //////////////////////////////
    $get_orders_previous_week=get_mandoob_orders_previous_week($mandoob_id);
    $response["weeklyEraning"]=$get_orders_previous_week;
    
   
    
    
   
    
}

  echo json_encode($response,JSON_UNESCAPED_UNICODE);
?>
