<?php

/*
 * Following code will list all the products
 */
// array for JSON response
$response = array();

// include db connect class
include("db_connect.php");

// connecting to db
$con = new DB_CONNECT();
$connection=$con->connect();

$connection->query("SET NAMES 'utf8'");

$connection->query("SET CHARACTER SET utf8");

$connection->query("SET SESSION collation_connection = 'utf8_unicode_ci'");

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET,POST,PUT,DELETE,OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

$required_parametrs=array('1'=>"lang",'2'=>'sub_service_id');
$errors=array();
foreach ($_GET as $key => $value) {
   if(in_array($key,$required_parametrs)){
     $key = array_search($key, $required_parametrs);
     unset($required_parametrs[$key]);

   }else{
     $errors[]="Parameter field is required:";
   }
}

if(count($required_parametrs)>0){
  //some parameters required
  $response["success"] = 0;
  if ($lang == "ar") {
      $response["message"] = "هناك بيانات مفقوده برجاء مراجعة بياناتك";
  } else {
      $response["message"] = $errors[0];
  }

}else{

   $lang=mysqli_real_escape_string($connection, trim($_GET['lang']));
   $sub_service_id=mysqli_real_escape_string($connection, trim($_GET['sub_service_id']));

    $sub_service_data=view_sub_service_ByID($sub_service_id);
    $response["sub_service_data"]=$sub_service_data;

}

  echo json_encode($response);
?>
