<?php

/*
 * Following code will list all the products
 */
// array for JSON response
$response = array();

// include db connect class
include("db_connect.php");

// connecting to db
$con = new DB_CONNECT();
$connection=$con->connect();

$connection->query("SET NAMES 'utf8'");

$connection->query("SET CHARACTER SET utf8");

$connection->query("SET SESSION collation_connection = 'utf8_unicode_ci'");

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET,POST,PUT,DELETE,OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

$required_parametrs=array("pickup_id","destination_id","money","lang");
$errors=array();
//print_r($required_parametrs);
foreach ($_GET as $key => $value) {
   if(in_array($key,$required_parametrs)){
     $key = array_search($key, $required_parametrs);
     unset($required_parametrs[$key]);
   }else{
     $errors[]="Parameter field is required:";
   }
}

$language=$_GET['lang'];

if(count($required_parametrs)>0){
  //some parameters required
  $response["success"] = 0;
  if ($language == "ar") {
      $response["message"] = "هناك بيانات مفقوده برجاء مراجعة بياناتك";
  } else {
      $response["message"] = $errors[0];
  }
  
  $response["required_parameters"] = $required_parametrs;
}else{
    
   
    $pickup_id=$_GET['pickup_id'];
    $destination_id=$_GET['destination_id'];
    $money=$_GET['money'];
    
    
    //get pickup lat and lang 
    $pickup_data=$connection->query("SELECT * FROM `pickup_destinations` WHERE `id`='$pickup_id'    LIMIT 1");
    $pickup_row=mysqli_fetch_assoc($pickup_data);
    $pick_lat=$pickup_row['lat'];
    $pick_lang=$pickup_row['lang'];
    
    
    //get destination lat and lang 
    $destination_data=$connection->query("SELECT * FROM `pickup_destinations` WHERE `id`='$destination_id'   LIMIT 1");
    $destination_row=mysqli_fetch_assoc($destination_data);
    $destination_lat=$destination_row['lat'];
    $destination_lang=$destination_row['lang'];
    
     //calculate the distance 
      $distance=haversineGreatCircleDistance($destination_lat, $destination_lang, $pick_lat, $pick_lang,$earthRadius = 6371000); //in meters
      $distance=number_format($distance/1000,3);
    
    //get the fees of one killo meter and * in the distance
     $fees_data=$connection->query("SELECT * FROM `fees`  LIMIT 1");
     $fees_row=mysqli_fetch_assoc($fees_data);
     $price_of_killo=$fees_row['price_of_killo'];
     $total_money=$money+$price_of_killo;
      
 
     
        // successfully inserted into database
     $response["success"] = 1;
        
     $response["money"] =number_format($money,3); 
     $response["fees"] =$price_of_killo ;
     $response["total_money"] =number_format($total_money,3); ;
    
}


  echo json_encode($response);

?>