<?php

date_default_timezone_set('Asia/Bahrain');

error_reporting(1);

/*Notifications*/

function sendMessage($params, $addNotSend) {
    global $con;
    if ($params["registration_id"] && $params["data"]) {
        switch ($params["pushtype"]) {
            case "ios":
                 $ress = sendMessageIos($params["registration_id"], $params);
                return $ress;
               if ($addNotSend['type'] != 'message') {
                    insertIntoNotSend($addNotSend);
                }
                break;
            case "android":
                $ress = sendMessageAndroid($params["registration_id"], $params);
                return $ress = json_decode($ress);
                if ($ress) {
                    if ($ress->success == 0) {
                      // updateDevices($params['data']['client_id'], $params["registration_id"]);
                    }
                    if ($addNotSend['type'] != 'message') {
                        insertIntoNotSend($addNotSend);
                    }
                }
                break;
        }
    }
}


function sendMessageChat($params, $addNotSend) {
    global $con;


    if ($params["registration_id"] && $params["data"]) {
        switch ($params["pushtype"]) {
            case "ios":
                 $ress = sendMessageChatIos($params["registration_id"], $params);
                if ($addNotSend['type'] != 'message') {
                    insertIntoNotSend($addNotSend);
                }
                break;
            case "android":
                $ress = sendMessageAndroid($params["registration_id"], $params);
                $ress = json_decode($ress);
                if ($ress) {
                    if ($ress->success == 0) {
                        //updateDevices($params['data']['client_id'], $params["registration_id"]);
                    }
                    if ($addNotSend['type'] != 'message') {
                        insertIntoNotSend($addNotSend);
                    }
                }
                break;
        }
    }
}






function sendMessageMandoob($params, $addNotSend) {
    global $con;


    if ($params["registration_id"] && $params["data"]) {
        switch ($params["pushtype"]) {
            case "ios":
                 $ress = sendMessageIosMandoob($params["registration_id"], $params);
                if ($addNotSend['type'] != 'message') {
                    insertIntoNotSend($addNotSend);
                }
                break;
            case "android":
                $ress = sendMessageAndroid($params["registration_id"], $params);
                $ress = json_decode($ress);
                return $ress;
                if ($ress) {
                    if ($ress->success == 0) {
                      //  updateDevices($params['data']['client_id'], $params["registration_id"]);
                    }
                    if ($addNotSend['type'] != 'message') {
                        insertIntoNotSend($addNotSend);
                    }
                }
                break;
        }
    }
}


function insertIntoNotSend($temp) {
    
    global $con;
    $connection=$con->connect();
    arabic_solve($connection);
    
    $sql = "SELECT * FROM `notifications` WHERE ";
    $sql.=" `client_id`='{$temp['client_id']}' AND ";
    $sql.=" `text_id`='{$temp['text_id']}' AND ";
    $sql.=" `text`='{$temp['text']}' AND ";
    $sql.=" `type`='{$temp['type']}'";
    $res = $connection->query($sql);
    $notifications_count = mysqli_num_rows($res);
    
    if ($notifications_count == 0) {
        $sql = "INSERT INTO `notifications` SET  `client_id`='{$temp['client_id']}' ,`text`='{$temp['text']}',`text_en`='{$temp['text_en']}',`type`='{$temp['type']}',`text_id`='{$temp['text_id']}',`date`='" . date('Y-m-d H:i:s') . "'";
        $res = $connection->query($sql);
        return mysqli_insert_id($connection);
    }
    
}


function record_notification_database($data){
     global $con;
     $connection=$con->connect();
     arabic_solve($connection);

    //insert into tables
     $title=$data['title'];
     $title_en=$data['title_en'];
      
     $type=$data['type'];
     $order_id=$data['order_id'] ;
     $mandoob_id=$data['mandoob_id'] ;
     
     $order_status=$data['order_status'];
    
     $check=$connection->query("INSERT INTO `notifications_mandoob` (`mandoob_id`, `order_id`, `type`,`title`,`title_en`) VALUES ('$mandoob_id','$order_id','$type','$title','$title_en')");
     if($check){
         return 1;
     }else{
         
          return 0;
     }
    
    
}



function get_mandoob_rate($mandoob_id){
    
     global $con;
     
     $connection=$con->connect();
     
     arabic_solve($connection);
 
     $query=$connection->query("SELECT sum(`rate`)  as `total_rate` , COUNT(`mandoob_id`) as `total_count` FROM `order_rates` WHERE `mandoob_id`='$mandoob_id' AND `type`='2' ");//type 2 mean from client to mandoob 
    
     $data=mysqli_fetch_assoc($query);  
    
    $rate=$data["total_rate"]?:"0";
    
    $count=$data["total_count"]?:"1";
    
    return $rate/$count;
}



function get_mandoob_orders_count($mandoob_id){
    
     global $con;
     
     $connection=$con->connect();
     
     arabic_solve($connection);
 
     $query=$connection->query("SELECT COUNT(`mandoob_id`) as `total_count` FROM `orders` WHERE `mandoob_id`='$mandoob_id' AND `status`='2' ");
    
     $data=mysqli_fetch_assoc($query);  
    
   
    
    $count=$data["total_count"]?:"0";
    
    return $count;
}


function get_order_status($order_id){
    
      global $con;
     
     $connection=$con->connect();
     
     arabic_solve($connection);
 
     $query=$connection->query("SELECT * FROM `orders` WHERE `id`='$order_id'  LIMIT 1  ");
    
     $data=mysqli_fetch_assoc($query);  
    
   
    
    $status=$data["status"];
    
    return $status;
    
    
}
function get_mandoob_acceptance_rate($mandoob_id){
    
     global $con;
     
     $connection=$con->connect();
     
     arabic_solve($connection);
 
     $query=$connection->query("SELECT COUNT(`mandoob_id`) as `total_count` FROM `orders` WHERE `mandoob_id`='$mandoob_id' AND `status`='2' ");
    
     $data=mysqli_fetch_assoc($query);  
    
     $count=$data["total_count"]?:"0";
    
     return $count;
    
}







function sendMessageIos($registration_id, $params) {

   $url = "https://fcm.googleapis.com/fcm/send";

    $serverKey = 'AAAADTc3b_A:APA91bHiBcVtZ2HS-PUXFsD96BkfEYgIjvUogAb_F5nN96Pdw18dOhptktzlTF3OLFzyB2hpeO1e2U_Lm7mOmklRr2iqSKOaJrf5faWilBQ_dzvKrL7RZV_o-69RhxCC4YwIkeQ3cAuh';
     $title = "Al Mandoob";
    $body = $params['data']['title'];
    $type = $params['data']['type'];
    $order_id = $params['data']['order_id'];
    
     $order_status=$params['data']['order_status'];
     
     $mandoob_id=$params['data']['mandoob_id'];
     $mandoob_name=$params['data']['mandoob_name'];
     
     $mandoob_image=$params['data']['mandoob_image'] ;
     $mandoob_phone=$params['data']['mandoob_phone'] ; 
     
     
     $order_data=$params['data']['order_data'];
     
     
     
     
    //'order_data'=>$order_data,'mandoob_id'=>$mandoob_id
    $notification = array('title' => $title, 'text' => $body, 'sound' => 'default', 'badge' => '1');
    
    $data = array('type' => $type,'order_id'=>$order_id,'order_status'=>$order_status,'mandoob_name'=>$mandoob_name,'mandoob_id'=>$mandoob_id,'mandoob_image'=>$mandoob_image,'mandoob_phone'=>$mandoob_phone);
    // $data_2 = array('order_id' => $order_id);
    $arrayToSend = array('to' => $registration_id, 'notification' => $notification, 'priority' => 'high', "data" => $data);
    $json = json_encode($arrayToSend);
    $headers = array();
    $headers[] = 'Content-Type: application/json';
    $headers[] = 'Authorization: key=' . $serverKey;
    $ch = curl_init();
    
    
    curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send'); //For firebase, use https://fcm.googleapis.com/fcm/send
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
    
    //Send the request
    $response = curl_exec($ch);
    //Close request
    if ($response === FALSE) {
        die('FCM Send Error: ' . curl_error($ch));
    }
    curl_close($ch);
    // echo die(var_dump($response));
    return $response;
}




function sendMessageChatIos($registration_id, $params) {

   $url = "https://fcm.googleapis.com/fcm/send";

    $serverKey = 'AAAADTc3b_A:APA91bHiBcVtZ2HS-PUXFsD96BkfEYgIjvUogAb_F5nN96Pdw18dOhptktzlTF3OLFzyB2hpeO1e2U_Lm7mOmklRr2iqSKOaJrf5faWilBQ_dzvKrL7RZV_o-69RhxCC4YwIkeQ3cAuh';
     $title = "Al Mandoob";
    $body = $params['data']['title'];
    $type = $params['data']['type'];
    $order_id = $params['data']['order_id'];
    
     $order_status=$params['data']['order_status'];
     
     $mandoob_id=$params['data']['mandoob_id'];
     $mandoob_name=$params['data']['mandoob_id'];
     
     $mandoob_image=$params['data']['mandoob_image'] = 
     $mandoob_phone=$params['data']['mandoob_phone'] = 
     
     
     $order_data=$params['data']['order_data'];
     
     
     
     
    //'order_data'=>$order_data,'mandoob_id'=>$mandoob_id
    $notification = array('title' => $title, 'text' => $body, 'sound' => 'default', 'badge' => '1');
    
    $data = array('type' => $type,'order_id'=>$order_id,'order_status'=>$order_status,'mandoob_name'=>$mandoob_name,'mandoob_id'=>$mandoob_id,'mandoob_image'=>$mandoob_image,'mandoob_phone'=>$mandoob_phone);
    // $data_2 = array('order_id' => $order_id);
    $arrayToSend = array('to' => $registration_id, 'notification' => $notification, 'priority' => 'high', "data" => $data);
    $json = json_encode($arrayToSend);
    $headers = array();
    $headers[] = 'Content-Type: application/json';
    $headers[] = 'Authorization: key=' . $serverKey;
    $ch = curl_init();
    
    
    curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send'); //For firebase, use https://fcm.googleapis.com/fcm/send
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
    
    //Send the request
    $response = curl_exec($ch);
    //Close request
    if ($response === FALSE) {
        die('FCM Send Error: ' . curl_error($ch));
    }
    curl_close($ch);
    // echo die(var_dump($response));
    return $response;
}




function sendMessageIosMandoob($registration_id, $params) {

   $url = "https://fcm.googleapis.com/fcm/send";

    $serverKey = 'AAAADTc3b_A:APA91bHiBcVtZ2HS-PUXFsD96BkfEYgIjvUogAb_F5nN96Pdw18dOhptktzlTF3OLFzyB2hpeO1e2U_Lm7mOmklRr2iqSKOaJrf5faWilBQ_dzvKrL7RZV_o-69RhxCC4YwIkeQ3cAuh';
     $title = "Al Mandoob";
    $body = $params['data']['title'];
    $type = $params['data']['type'];
    $order_id = $params['data']['order_id'];
    
     $order_status=$params['data']['order_status'];
     
     $mandoob_id=$params['data']['mandoob_id'];
     $mandoob_name=$params['data']['mandoob_id'];
     
     $mandoob_image=$params['data']['mandoob_image'] = 
     $mandoob_phone=$params['data']['mandoob_phone'] = 
     
     
     $order_data=$params['data']['order_data'];
     
     
     
     
    //'order_data'=>$order_data,'mandoob_id'=>$mandoob_id
    $notification = array('title' => $title, 'text' => $body, 'sound' => 'default', 'badge' => '1');
    
    $data = array('type' => $type,'order_id'=>$order_id,'order_status'=>$order_status,'mandoob_name'=>$mandoob_name,'mandoob_id'=>$mandoob_id,'mandoob_image'=>$mandoob_image,'mandoob_phone'=>$mandoob_phone);
    // $data_2 = array('order_id' => $order_id);
    $arrayToSend = array('to' => $registration_id, 'notification' => $notification, 'priority' => 'high', "data" => $data);
    $json = json_encode($arrayToSend);
    $headers = array();
    $headers[] = 'Content-Type: application/json';
    $headers[] = 'Authorization: key=' . $serverKey;
    $ch = curl_init();
    
 
    
    curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send'); //For firebase, use https://fcm.googleapis.com/fcm/send

    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
    
    //Send the request
    $response = curl_exec($ch);
    //Close request
    if ($response === FALSE) {
        die('FCM Send Error: ' . curl_error($ch));
    }
    curl_close($ch);
    // echo die(var_dump($response));
    return $response;
}





function sendMessageAndroid($registration_id, $params) {

    define('API_ACCESS_KEY', 'AAAADTc3b_A:APA91bHiBcVtZ2HS-PUXFsD96BkfEYgIjvUogAb_F5nN96Pdw18dOhptktzlTF3OLFzyB2hpeO1e2U_Lm7mOmklRr2iqSKOaJrf5faWilBQ_dzvKrL7RZV_o-69RhxCC4YwIkeQ3cAuh');
    $registrationIds = array($registration_id);
    $msg = array
        (
         'message' => $params['data']['title']?:" ",
         'type' => $params['data']['type']?:" ",
         'order_id' => $params['data']['order_id']?:" ",
         'order_status'=>$params['data']['order_status']?:" ",
         'client_id'=>$params['data']['client_id']?:" ",
         'mandoob_id'=>$params['data']['mandoob_id']?:" ",
         'mandoob_name'=>$params['data']['mandoob_id']?:" ",
         'mandoob_image'=>$params['data']['mandoob_image']?:" ",
         'mandoob_phone'=>$params['data']['mandoob_phone']?:" ",
         'title' => 'Alert',
         'subtitle' => 'Alert message!',
         'vibrate' => 1,
         'sound' => 'default',
         'largeIcon' => 'large_icon',
         'smallIcon' => 'small_icon'
    );

    $fields = array
        (
            'registration_ids' => $registrationIds,
            'data' => $msg
        );

    $headers = array
        (
        'Authorization: key=' . API_ACCESS_KEY,
        'Content-Type: application/json'
    );

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send'); 

    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
    $result = curl_exec($ch);
    curl_close($ch);
    return $result;
}




/*End Notification*/



function get_client_notifcations($client_id,$language){
    
    global $con;
    $connection=$con->connect();
    arabic_solve($connection);
    $data=array();
    $query = $connection->query("SELECT * FROM `notifications` WHERE `client_id`='$client_id' ORDER By `id` DESC ");
    while($row=mysqli_fetch_assoc($query)){
        
        if($language!='ar'){
            $row["text"]=$row['text_en'];
        }
        
        unset($row['text_en']);
        
        $data[]=$row;
    }

    return $data;
}


function get_mandoob_notifcations($mandoob_id){
    
    global $con;
    
    $connection=$con->connect();
    
    arabic_solve($connection);
    
    $data=array();
    
    $query = $connection->query("SELECT * FROM `notifications_mandoob` WHERE `mandoob_id`='$mandoob_id' ORDER BY `id` DESC ");
    
    while($row=mysqli_fetch_assoc($query)){
        
        $data[]=$row;
        
    }

    return $data;
    
}




function arabic_solve($connection){
    
    
    
$connection->query("SET NAMES 'utf8'");

$connection->query("SET CHARACTER SET utf8");

$connection->query("SET SESSION collation_connection = 'utf8_unicode_ci'");

}

function check_register_phone($client_phone) {

    $result = mysql_query("SELECT * FROM `clients` WHERE `client_phone`='$client_phone' ORDER BY `client_id` DESC") or die(mysql_error());

    $row = mysql_fetch_array($result);

    $client_phone = $row['client_phone'];

    return $client_phone;
}

function view_regions($lang){
    
     global $con;
    $connection=$con->connect();
    arabic_solve($connection);
    $result = $connection->query("SELECT * FROM `regions` WHERE `display`=1  ORDER BY `id` DESC ");
    $collection=array();
    
    while($data = mysqli_fetch_assoc($result)){
   
        if($lang=="ar"){
            $data['name']=$data['name_ar'];
        }else{
            $data['name']=$data['name_en'];
        }
          unset($data['name_ar']);
         unset($data['name_en']);
      $collection[]=$data ;
      
    } 

    return $collection;
    
    
}


function get_branch_from_region_id($region_id) {

    $result = mysql_query("SELECT * FROM `branches_regions` WHERE `region_id`='$region_id' ORDER BY `id` DESC") or die(mysql_error());

    $row = mysql_fetch_array($result);

    $branche_id = $row['branche_id'];

    return $branche_id;
}

function check_register($client_email) {

    $result = mysql_query("SELECT * FROM `clients` WHERE `client_email`='$client_email' ORDER BY `client_id` DESC") or die(mysql_error());

    $row = mysql_fetch_array($result);

    $client_email = $row['client_email'];

    return $client_email;
}
function getRegionName($regionID) {

    global $con;
    $connection=$con->connect();
      arabic_solve($connection);
    $query = $connection->query("SELECT * FROM `regions` WHERE `id`='$regionID' LIMIT 1");
    $row_select = mysqli_fetch_array($query);

    $region_name_ar = $row_select['name_ar'];
    return $region_name_ar;
    
}

function haversineGreatCircleDistance($latitudeFrom, $longitudeFrom, $latitudeTo, $longitudeTo, $earthRadius = 6371000)
{
  // convert from degrees to radians
  $latFrom = deg2rad($latitudeFrom);
  $lonFrom = deg2rad($longitudeFrom);
  $latTo = deg2rad($latitudeTo);
  $lonTo = deg2rad($longitudeTo);

  $latDelta = $latTo - $latFrom;
  $lonDelta = $lonTo - $lonFrom;

  $angle = 2 * asin(sqrt(pow(sin($latDelta / 2), 2) +
    cos($latFrom) * cos($latTo) * pow(sin($lonDelta / 2), 2)));
  return $angle * $earthRadius;
}


function getDistrictName($DistrictID) {

    global $con;
    $connection=$con->connect();
    $query = $connection->query("SELECT * FROM `districts` WHERE `id`='$DistrictID' LIMIT 1");
    $row_select = mysqli_fetch_array($query);

    $region_name_ar = $row_select['name'];
    return $region_name_ar;
}

function get_clinet_image($client_id){
     
     global $con;
    $connection=$con->connect();
    $query = $connection->query("SELECT * FROM `clients` WHERE `id`='$client_id' LIMIT 1 ");
    $row_select = mysqli_fetch_assoc($query);
    return $row_select["image"]?:"";
    
}
function get_clinet_name_from_id($client_id){
    
    
    global $con;
    $connection=$con->connect();
    $query = $connection->query("SELECT * FROM `clients` WHERE `id`='$client_id' LIMIT 1 ");
    $row_select = mysqli_fetch_assoc($query);
    return $row_select["name"]?:"";
    
    
}


function get_mandoob_image($mandoob_id){
    
      global $con;
    $connection=$con->connect();
    $query = $connection->query("SELECT * FROM `mandoobs` WHERE `id`='$mandoob_id' LIMIT 1 ");
    $row_select = mysqli_fetch_assoc($query);
    return $row_select["image"]?:"";
    
}

function calculateFileSize($file){

    $ratio = 16000; //bytespersec

    if (!$file) {

      //  exit("Verify file name and it's path");

    }

    $file_size = filesize($file);

    if (!$file_size)
    //    exit("Verify file, something wrong with your file");

    return $duration = ($file_size / $ratio);
    $minutes = floor($duration / 60);
    $seconds = $duration - ($minutes * 60);
    $seconds = round($seconds);
    return "$minutes:$seconds minutes";

}


function get_chat($client_id,$mandoob_id,$order_id){
    
    
     global $con;
    $connection=$con->connect();
    
      arabic_solve($connection);
    $query = $connection->query("SELECT * FROM `chats` WHERE `client_id`='$client_id' AND `mandoob_id`='$mandoob_id' AND `order_id`='$order_id' ");
    $data=array();
    while($row_select = mysqli_fetch_assoc($query)){
        
        $row_select["client_image"]=get_clinet_image($client_id);
        $row_select["client_name"]=get_clinet_name_from_id($client_id);
        $row_select["mandoob_image"]=get_mandoob_image($mandoob_id);
        
        
        $data[]=$row_select;
        
    }

   
    return $data;
    
}


function ComapnyImages($company_id){

  global $con;
  $connection=$con->connect();
  $query = $connection->query("SELECT * FROM `company_images` WHERE `company_id`='$company_id' ORDER BY `id` ASC");
  $data=array();
  $data_collection=array();
  while ($row = mysqli_fetch_assoc($query)) {
      $name=$row['name'];
      $get_image_ext = explode('.', $name);
      $image_ext = strtolower(end($get_image_ext));
      $data['image']="http://www.crt4rent.com/system/api/uploads/company/".$company_id."/".$name;

      $data_collection[]=$data;
  }

  return $data_collection;


}

function ModelNameById($model_id){
  global $con;
  $connection=$con->connect();
  $query=$connection->query("SELECT * FROM `car_models` WHERE `id`='$model_id' LIMIT 1");
  $model_data = mysqli_fetch_array($query);
  $name=$model_data['name'];
  return $name;
}

function ComapnyModels($company_id){

  global $con;
  $connection=$con->connect();
  $query = $connection->query("SELECT * FROM `company_models` WHERE `company_id`='$company_id' ORDER BY `id` ASC");
  $data=array();
  $data_collection=array();
  while ($row = mysqli_fetch_assoc($query)) {
      $model_id=$row['car_model_id'];
      $data['model_id']=$model_id;
      $data['model_name']=ModelNameById($model_id);

      $data_collection[]=$data;
  }

  return $data_collection;


}

function view_company_ByID($company_id){

  global $con;
  $connection=$con->connect();
  $query = $connection->query("SELECT * FROM `companies` WHERE `id`='$company_id' ");
  $data=array();
  $data_collection=array();
  while ($row = mysqli_fetch_assoc($query)) {
      $data['id'] = $row['id'];
      $data['name'] = $row['name'];
      $data['phone'] = $row['phone'];
      $data['region_id'] = $row['region_id'];
      $data['district_id']=$row['district_id'];
      $data['about'] = $row['about'];
      $data['region_name']=getRegionName($data['region_id']);
      $data['district_name']=getDistrictName($data['district_id']);
      $data['images']=ComapnyImages($data['id']);
      $data['models']=ComapnyModels($data['id']);
      $data['working_Hours']=companyWorkingHours($data['id']);
      $data_collection[]=$data;
  }

  return $data_collection;


}

function get_current_orders($client_id){
    

    //make status = 0 to make Deleopers check properties
     global $con;
    $connection=$con->connect();
     arabic_solve($connection);
    $query_select = $connection->query("SELECT * FROM `orders` WHERE `client_id`='$client_id' AND (`status`=0 OR `status`=1) ORDER BY `id` DESC");
    $data=array();
   
    while($row = mysqli_fetch_assoc($query_select)){
         $order_id=$row['id'];
         
       
         
         $row['order_images']=get_order_images($order_id);
          $row['amout_pay_for_order']=number_format($row['amout_pay_for_order'],3);
         $pickup_id=$row['pickup_id'];
         $destination_id=$row['destination_id'];
          $mandoob_id=$row['mandoob_id'];
            $row['is_rate']=check_client_rate_order($order_id,$client_id);
           $row['mandoob_info']=get_mandoob_data($mandoob_id);
           $row['destinati_info']=clinet_address_info($destination_id);
           $row['pickup_info']=clinet_address_info($pickup_id);
      // $row['pickup_info']=clinet_address_info($pickup_id);
        
        $data[]=$row;
    }
    return $data;
    
}


function get_order_by_mandoob_id($mandoob_id){
    
      
    //make status = 0 to make Deleopers check properties
     global $con;
    $connection=$con->connect();
      arabic_solve($connection);
    $query_select = $connection->query("SELECT * FROM `orders` WHERE `mandoob_id`='$mandoob_id' ORDER BY `date_added` DESC LIMIT 1 ");
    $data=mysqli_fetch_assoc($query_select);
    $order_id=$data["id"];
    
   return get_order_by_id($order_id);
}









function get_order_by_id($order_id){
    
    //make status = 0 to make Deleopers check properties
     global $con;
    $connection=$con->connect();
      arabic_solve($connection);
    $query_select = $connection->query("SELECT * FROM `orders` WHERE `id`='$order_id' ");
    $data=array();
   
    while($row = mysqli_fetch_assoc($query_select)){
         $order_id=$row['id'];
         
         $row['order_images']=get_order_images($order_id);
         
         $client_id=$row['client_id'];
         
         $pickup_id=$row['pickup_id'];
         $destination_id=$row['destination_id'];
         $mandoob_id=$row['mandoob_id'];
         $row['is_rate']=check_client_rate_order($order_id,$client_id);
         $row['mandoob_info']=get_mandoob_data($mandoob_id);
         $row['destinati_info']=clinet_address_info($destination_id);
         $row['pickup_info']=clinet_address_info($pickup_id);
          $row['client_phone']=get_client_phone_from_id($client_id);
          $row['client_name']=get_client_name_from_id($client_id);
        
        
        
        $data[]=$row;
    }
    return $data;
    
}

function get_order_images($order_id){
    
     global $con;
    $connection=$con->connect();
    $query_select = $connection->query("SELECT * FROM `order_photoes` WHERE `order_id`='$order_id'  ORDER BY `id` DESC");
    $data=array();
   
    while($row = mysqli_fetch_assoc($query_select)){
        $data[]=$row;
    };
    
    return $data;
    
    
    
}


function get_previous_orders($client_id){
     
     global $con;
    $connection=$con->connect();
     arabic_solve($connection);
    $query_select = $connection->query("SELECT * FROM `orders` WHERE `client_id`='$client_id' AND `status`=3 ORDER BY `id` DESC");
    $data=array();
   
    while($row = mysqli_fetch_assoc($query_select)){
         $order_id=$row['id'];
         $row['order_images']=get_order_images($order_id);
        $pickup_id=$row['pickup_id'];
        $destination_id=$row['destination_id'];
        
        $mandoob_id=$row['mandoob_id'];
        
        $row['is_rate']=check_client_rate_order($order_id,$client_id);
        
        $row['mandoob_info']=get_mandoob_data($mandoob_id);
        $row['destinati_info']=clinet_address_info($pickup_id);
        $row['pickup_info']=clinet_address_info($destination_id);
        
        $data[]=$row;
    }
    return $data;
    
    
    
}

function get_mandoob_previous_orders($mandoob_id){
    
    
      global $con;
    $connection=$con->connect();
     arabic_solve($connection);
    $query_select = $connection->query("SELECT * FROM `orders` WHERE `mandoob_id`='$mandoob_id' AND `status`=3 ORDER BY `id` DESC");
    $data=array();
   
    while($row = mysqli_fetch_assoc($query_select)){
         $order_id=$row['id'];
         $row['order_images']=get_order_images($order_id);
        $pickup_id=$row['pickup_id'];
        $destination_id=$row['destination_id'];
        
        $mandoob_id=$row['mandoob_id'];
        
        $row['is_rate']=check_client_rate_order($order_id,$client_id);
        
        $row['mandoob_info']=get_mandoob_data($mandoob_id);
        $row['destinati_info']=clinet_address_info($pickup_id);
        $row['pickup_info']=clinet_address_info($destination_id);
        
        $data[]=$row;
    }
    return $data;
    
    
    
    
}



function get_mandoob_current_orders($mandoob_id){
    
    
      global $con;
    $connection=$con->connect();
     arabic_solve($connection);
    $query_select = $connection->query("SELECT * FROM `orders` WHERE `mandoob_id`='$mandoob_id' AND `status`=1 ORDER BY `id` DESC");
    $data=array();
   
    while($row = mysqli_fetch_assoc($query_select)){
         $order_id=$row['id'];
         $row['order_images']=get_order_images($order_id);
        $pickup_id=$row['pickup_id'];
        $destination_id=$row['destination_id'];
        
        $mandoob_id=$row['mandoob_id'];
        
        $row['is_rate']=check_client_rate_order($order_id,$client_id);
        
        $row['mandoob_info']=get_mandoob_data($mandoob_id);
        $row['destinati_info']=clinet_address_info($pickup_id);
        $row['pickup_info']=clinet_address_info($destination_id);
        
        $data[]=$row;
    }
    return $data;
    
}



function get_orders_filter($mandoob_id,$date_from,$date_to){
    
     global $con;
    $connection=$con->connect();
     arabic_solve($connection);
    $query_select = $connection->query("SELECT * FROM `orders` WHERE `mandoob_id`='$mandoob_id' AND `status`=3  AND (date(`date_time_delivery`)>='$date_from' AND date(`date_time_delivery`)<='$date_to' ) ");
    $data=array();
   
    while($row = mysqli_fetch_assoc($query_select)){
        $explode=explode(" ",$row["date_time_delivery"]);
        $row["date"]=$explode[0];
        $row["time"]=$explode[1];
        $data[]=$row;
    }
    
    return $data;
}



function get_mandoob_orders_previous_week($mandoob_id){
    
    
    global $con;
    $connection=$con->connect();
    arabic_solve($connection);
    
    $date = strtotime("-7 day");
     $start=date('Y-m-d', $date);
     $end=date('Y-m-d');
    
     $query_select = $connection->query("SELECT `status`,date(`date_time_delivery`)as date_time,sum(`amout_pay_for_order`)as total_pay,sum(`total`)as total_sum FROM `orders` WHERE 
                                        `mandoob_id`='$mandoob_id' AND `status`=3  AND (date(`date_time_delivery`)>='$start' AND date(`date_time_delivery`)<='$end' )  GROUP BY `date_time` ");
    $data=array();
   $days_number=array(1,2,3,4,5,6,7);
   $days_names=array(1=>"Mon",2=>"Tue",3=>"Wed",4=>"Thur",5=>"Fri",6=>"Sat",7=>"Sun");
    while($row = mysqli_fetch_assoc($query_select)){
        $date =  $row["date_time"];
        $nameOfDay = date('D', strtotime($date));
        $day_number = date('N', strtotime($date));
        
        if(in_array($day_number,$days_number)){
         $key = array_search($day_number, $days_number);
         unset($days_number[$key]);
    
       }
        
        $row["day_name"]=$nameOfDay;
        $data[]=$row;
    }
    
    $empty_days=array();
    foreach($days_number as $key=>$value){
       
        $empty_days["status"]=3;
        $empty_days["date_time"]=1;
        $empty_days["total_pay"]="0";
         $empty_days["day_name"]=  $days_names[$value];;
        
         $data[]=$empty_days;
        
    }
    
    return $data;
    
    
}




function clinet_address_info($id){
     global $con;
    $connection=$con->connect();
     arabic_solve($connection);
    $query_select = $connection->query("SELECT * FROM `pickup_destinations` WHERE `id`='$id' LIMIT 1 ");
    $data=array();
   
    while($row = mysqli_fetch_assoc($query_select)){
        $row["region_name"]=getRegionName($row['region']);
       $data[]=$row;
    }
    return $data;
}


function check_client_rate_order($order_id,$client_id){
    
    global $con;
    $connection=$con->connect();
    arabic_solve($connection);

    $query_select = $connection->query("SELECT * FROM `order_rates` WHERE `client_id`='$client_id' AND `order_id`='$order_id'  AND `type`=2 ");
    $count=mysqli_num_rows($query_select);
    
    return $count;
    
}


function get_client_places($client_id,$lang){
     global $con;
    $connection=$con->connect();
    arabic_solve($connection);

    //$query_select = $connection->query("SELECT * FROM `client_places` WHERE `client_id`='$client_id' ORDER BY `id` DESC");

    $data=array();
   
    // while($row = mysqli_fetch_assoc($query_select)){
    //   $data[]=$row;
    // };
    
    $query_select = $connection->query("SELECT * FROM `pickup_destinations` WHERE `client_id`='$client_id' ORDER BY `id` DESC");
     
    while($row = mysqli_fetch_assoc($query_select)){
       $region_id=$row["region"];
       $row["region_name"]=get_region_name_by_id($region_id,$lang);
       $data[]=$row;
    };
    
    
    return $data;
   
}

function get_region_name_by_id($region_id,$lang) {
     global $con;
    $connection=$con->connect();
     arabic_solve($connection);
    $region_name="";
    $result =  $connection->query("SELECT * FROM `regions` WHERE `id`='$region_id'");

    $row = mysqli_fetch_array($result);
   if($lang=="ar"){
       $region_name= $row['name_ar'];
   }else{
       $region_name= $row['name_en'];
   }
    // $region_name_ar = $row['region_name_ar'];

    return $region_name;
}



function companyWorkingHours($companie_id) {
    global $con;
    $connection=$con->connect();
    $query_select = $connection->query("SELECT * FROM `company_days_work` WHERE `company_id`='$companie_id' ORDER BY `day_number` ASC");
    $data=array();
    $x=0;
    while($row = mysqli_fetch_assoc($query_select)){
       $data[$x]=$row;
      $x++;
    };
    return $data;
}




function view_companies() {

    global $con;
    $connection=$con->connect();
    $query = $connection->query("SELECT * FROM `companies` ORDER BY `id` ASC");
    $data=array();
    $data_collection=array();
    while ($row = mysqli_fetch_assoc($query)) {
        $data['id'] = $row['id'];
        $data['name'] = $row['name'];
        $data['phone'] = $row['phone'];
        $data['region_id'] = $row['region_id'];
        $data['district_id']=$row['district_id'];
        $data['about'] = $row['about'];
        $data['region_name']=getRegionName($data['region_id']);
        $data['district_name']=getDistrictName($data['district_id']);
        $data['images']=ComapnyImages($data['id']);
        $data['models']=ComapnyModels($data['id']);
        $data['working_Hours']=companyWorkingHours($data['id']);
        $data_collection[]=$data;
    }

    return $data_collection;
}



function salonImages($salon_id){

  global $con;
  $connection=$con->connect();
  $query = $connection->query("SELECT * FROM `salon_images` WHERE `salon_id`='$salon_id' ORDER BY `id` ASC");
  $data=array();
  $data_collection=array();
  while ($row = mysqli_fetch_assoc($query)) {

      $data=$row;
      $data_collection[]=$data;
  }

  return $data_collection;


}


function salonWorkingHours($salon_id) {
    global $con;
    $connection=$con->connect();
    $query_select = $connection->query("SELECT * FROM `salon_working_times` WHERE `salon_id`='$salon_id' ORDER BY `day` ASC");
    $data=array();
    $x=0;
    while($row = mysqli_fetch_assoc($query_select)){
       $data[$x]=$row;
      $x++;
    };
    return $data;
}

function parentServiceNameByID($parent_id){

  global $con;
  $connection=$con->connect();
  $query = $connection->query("SELECT * FROM `parent_services` WHERE `id`='$parent_id' LIMIT 1 ");
  $data=array();
 $row = mysqli_fetch_assoc($query) ;
 $data["name"]=$row['name'];
 $data["name_en"]=$row['name_en'];
  return $data;


}


function subServiceNameByID($sub_id){

  global $con;
  $connection=$con->connect();
  $query = $connection->query("SELECT * FROM `sub_services` WHERE `id`='$sub_id' LIMIT 1 ");
  $data=array();
 $row = mysqli_fetch_assoc($query) ;
 $data["name"]=$row['name'];
 $data["name_en"]=$row['name_en'];
  return $data;


}


function salonServices($salon_id){

  global $con;
  $connection=$con->connect();
  $query = $connection->query("SELECT * FROM `salon_services` WHERE `salon_id`='$salon_id' ORDER BY `id` ASC");
  $data=array();
  $data_collection=array();
  while ($row = mysqli_fetch_assoc($query)) {
        $parent_service_id=$row['parent_service_id'];
        $sub_service_id=$row['sub_service_id'];
        $row["subServiceName"]=subServiceNameByID($sub_service_id);
        $row["parentServiceName"]=parentServiceNameByID($parent_service_id);
      $data=$row;
      $data_collection[]=$data;
  }

  return $data_collection;


}

function salonRates($salon_id){

  global $con;
  $connection=$con->connect();
  $query = $connection->query("SELECT * FROM `rates` WHERE `salon_id`='$salon_id' ORDER BY `id` ASC");
  $data=array();
  $data_collection=array();
  while ($row = mysqli_fetch_assoc($query)) {
       $client_id=$row['client_id'];
       $row['client_name']=get_client_name_from_id($client_id);
      $data=$row;
      $data_collection[]=$data;
  }

  return $data_collection;


}


function view_salons() {

    global $con;
    $connection=$con->connect();
    $query = $connection->query("SELECT * FROM `salons` ORDER BY `id` DESC");
    $data=array();
    $data_collection=array();
    while ($row = mysqli_fetch_assoc($query)) {
        $data["main_data"]=$row;
        $data["working_hour"]=salonWorkingHours($row['id']);
        $data["salonImages"]=salonImages($row['id']);
        $data['salonServices']=salonServices($row['id']);
        $data['salonRates']=salonRates($row['id']);
        $data_collection[]=$data;
    }

    return $data_collection;
}

function view_salon_ByID($salon_id){

    global $con;
    $connection=$con->connect();
    $query = $connection->query("SELECT * FROM `salons` WHERE `id`='$salon_id' LIMIT 1 ");
    $data=array();
    $data_collection=array();
    while ($row = mysqli_fetch_assoc($query)) {
        $data["main_data"]=$row;
        $data["working_hour"]=salonWorkingHours($row['id']);
        $data["salonImages"]=salonImages($row['id']);
        $data['salonServices']=salonServices($row['id']);
        $data['salonRates']=salonRates($row['id']);
        $data_collection[]=$data;
    }

    return $data_collection;


}



function view_parent_services(){

    global $con;
    $connection=$con->connect();
    $query = $connection->query("SELECT * FROM `parent_services` ORDER BY `id` DESC");
    $data=array();
    $data_collection=array();
    while ($row = mysqli_fetch_assoc($query)) {
        $data=$row;
        $data_collection[]=$data;
    }

    return $data_collection;


}

function view_parent_service_ByID($parent_service_id){


     global $con;
    $connection=$con->connect();
    $query = $connection->query("SELECT * FROM `parent_services` WHERE `id`='$parent_service_id' ");
    $data=array();
    $data_collection=array();
    while ($row = mysqli_fetch_assoc($query)) {
        $data=$row;
        $data_collection[]=$data;
    }

    return $data_collection;





}

function view_FAQs(){

    global $con;
    $connection=$con->connect();
    $query = $connection->query("SELECT * FROM `FAQ` ");
    $data=array();
    $data_collection=array();
    while ($row = mysqli_fetch_assoc($query)) {
        $data=$row;
        $data_collection[]=$data;
    }

    return $data_collection;



}

function view_about($lang){

     global $con;
    $connection=$con->connect();
      arabic_solve($connection);
    $query = $connection->query("SELECT * FROM `about` ");
    $data=array();
    $data_collection=array();
    while ($row = mysqli_fetch_assoc($query)) {
        if($lang!="ar"){
            $row['content']=$row['content_en'];
            $row['title']=$row['title_en'];
        }
        
        unset($row['content_en']);
        unset($row['title_en']);
        $data=$row;
        $data_collection[]=$data;
    }

    return $data_collection;




}

function view_terms_conditions(){
      global $con;
    $connection=$con->connect();
     arabic_solve($connection);
    $query = $connection->query("SELECT * FROM `terms_conditions` ");
    $data=array();
    $data_collection=array();
    while ($row = mysqli_fetch_assoc($query)) {
        
        $data=$row;
        $data_collection[]=$data;
    }

    return $data_collection;




}


function view_terms($lang){
      
      global $con;
      
      $connection=$con->connect();
      
     arabic_solve($connection);
     
     $query = $connection->query("SELECT * FROM `terms_conditions` LIMIT 1 ");
     $data=array();
     $data_collection=array();
    
    while ($row = mysqli_fetch_assoc($query)) {
         if($lang!="ar"){
            
            $row['conditions']=$row['conditions_en'];
            $row['terms']=$row['terms_en'];
             $row['privacy']=$row['privacy_en'];
            
        }
        
        unset($row['conditions_en']);
        unset($row['terms_en']);
        unset($row['privacy_en']);
        
        $data=$row;
      
    }

    return $data;




}


function view_sub_service_ByID($sub_service_id){


     global $con;
    $connection=$con->connect();
    $query = $connection->query("SELECT * FROM `sub_services` WHERE `id`='$sub_service_id' ");
    $data=array();
    $data_collection=array();
    while ($row = mysqli_fetch_assoc($query)) {
        $data=$row;
        $data_collection[]=$data;
    }

    return $data_collection;





}


function view_sub_services(){

    global $con;
    $connection=$con->connect();
    $query = $connection->query("SELECT * FROM `sub_services` ORDER BY `id` DESC");
    $data=array();
    $data_collection=array();
    while ($row = mysqli_fetch_assoc($query)) {
        $data=$row;
        $data_collection[]=$data;
    }

    return $data_collection;


}



function companiesName($companie_id) {

    global $con;
    $connection=$con->connect();

    $query_select = $connection->query("SELECT * FROM `companies` WHERE `id`='$companie_id' ORDER BY `id` LIMIT 1 ");
    $row_select = mysqli_fetch_array($query_select);
    $name = $row_select['name'];
    return $name;
}

function add_reservation($client_id,$car_id,$price,$price_per_day,$driver,
                                 $driver_additional,$recieved_another_place,
                                 $detials,$total_cost,$date_from,$date_to,
                                 $number_of_days
                        ){

  global $con;
  $connection=$con->connect();

  $query = $connection->query("
                                    INSERT INTO `reservations`(`id`, `client_id`, `car_id`, `price`, `price_per_day`, `driver`, `driver_additional`, `recieved_another_place`, `detials`, `status`, `total_cost`, `date_from`, `date_to`, `number_of_days`, `created_at`)
                                     VALUES (
                                       null,'$client_id','$car_id','$price','$price_per_day','$driver',
                                      '$driver_additional','$recieved_another_place',
                                       '$detials','0','$total_cost','$date_from','$date_to',
                                       '$number_of_days',
                                       '" . date("Y-m-d H:i:s") . "'
                                     )
                                  ");
 if($query){$inserted=1;}else{$inserted=0;}
  return $inserted;



}


function reservation_remove($client_id,$reservation_id){
  global $con;
  $connection=$con->connect();

  $query = $connection->query("DELETE FROM `reservations` WHERE  `client_id`='$client_id' AND `id`='$reservation_id'");
  if($query){
    $removed=1;
  }else{
    $removed=0;
  }

  return $removed;
}

function view_reservations_byStatus($client_id,$status){
  global $con;
  $connection=$con->connect();

  $query = $connection->query("SELECT * FROM `reservations` WHERE `client_id`='$client_id' AND `status`='$status' ORDER BY `id` DESC");

   $data=array();
   $data_collection=array();

  while ($row = mysqli_fetch_assoc($query)) {
        $id = $row['id'];
        $client_id=$row['client_id'];
        //from clinet_id get the name , email and phone
        $query_client=$connection->query("SELECT * FROM `clients` Where `id`='$client_id' LIMIT 1");
        $client_data=mysqli_fetch_assoc($query_client);
        $client_name=$client_data['name'];
        $client_email=$client_data['email'];
        $client_phone=$client_data['phone'];
        /////////////////////////////////////////////
        $car_id=$row['car_id'];
        //from car id get car name company name model name
        $query_car=$connection->query("SELECT * FROM `cars` Where `id`='$car_id' LIMIT 1");
        $car_data=mysqli_fetch_assoc($query_car);
        $data['car_name']=$car_name=$car_data['name'];
        $data['company_name']=$car_company_name=companiesName($car_data['company_id']);
        $data['car_model_name']=$car_model_name=ModelNameById($car_data['car_model_id']);

      $data['price']=$price = $row['price'];
      $data['price_per_day']=  $price_per_day=$row['price_per_day'];
      $data['driver']=  $driver=$row['driver'];
      $data['driver_additional']=  $driver_additional=$row['driver_additional'];
      $data['recieved_another_place']=  $recieved_another_place = $row['recieved_another_place'];
      $data['detials']=  $detials = $row['detials'];
      $data['status']=  $status = $row['status'];
      $data['total_cost']=  $total_cost = $row['total_cost'];
      $data['date_from']=  $date_from = $row['date_from'];
      $data['date_to']=  $date_to = $row['date_to'];
      $data['number_of_days']=  $number_of_days = $row['number_of_days'];
      $data['created_at']=  $created_at = $row['created_at'];
      if($data['status']==0){$data['status']="pending";}elseif($data['status']==1){$data['status']="accepted";}else{$data['status']="refuesed";}
      $data_collection[]=$data;

  }
  return $data_collection;

}

function view_reservations_byID($client_id,$reservation_id){

  global $con;
  $connection=$con->connect();

  $query = $connection->query("SELECT * FROM `reservations` WHERE `client_id`='$client_id' AND `id`='$reservation_id' ORDER BY `id` DESC");

   $data=array();
   $data_collection=array();

  while ($row = mysqli_fetch_assoc($query)) {
        $id = $row['id'];
        $client_id=$row['client_id'];
        //from clinet_id get the name , email and phone
        $query_client=$connection->query("SELECT * FROM `clients` Where `id`='$client_id' LIMIT 1");
        $client_data=mysqli_fetch_assoc($query_client);
        $client_name=$client_data['name'];
        $client_email=$client_data['email'];
        $client_phone=$client_data['phone'];
        /////////////////////////////////////////////
        $car_id=$row['car_id'];
        //from car id get car name company name model name
        $query_car=$connection->query("SELECT * FROM `cars` Where `id`='$car_id' LIMIT 1");
        $car_data=mysqli_fetch_assoc($query_car);
        $data['car_name']=$car_name=$car_data['name'];
        $data['company_name']=$car_company_name=companiesName($car_data['company_id']);
        $data['car_model_name']=$car_model_name=ModelNameById($car_data['car_model_id']);

      $data['price']=$price = $row['price'];
      $data['price_per_day']=  $price_per_day=$row['price_per_day'];
      $data['driver']=  $driver=$row['driver'];
      $data['driver_additional']=  $driver_additional=$row['driver_additional'];
      $data['recieved_another_place']=  $recieved_another_place = $row['recieved_another_place'];
      $data['detials']=  $detials = $row['detials'];
      $data['status']=  $status = $row['status'];
      $data['total_cost']=  $total_cost = $row['total_cost'];
      $data['date_from']=  $date_from = $row['date_from'];
      $data['date_to']=  $date_to = $row['date_to'];
      $data['number_of_days']=  $number_of_days = $row['number_of_days'];
      $data['created_at']=  $created_at = $row['created_at'];
      if($data['status']==0){$data['status']="pending";}elseif($data['status']==1){$data['status']="accepted";}else{$data['status']="refuesed";}
      $data_collection[]=$data;

  }
  return $data_collection;



}


function view_reservations($clinet_id) {

    global $con;
    $connection=$con->connect();

    $query = $connection->query("SELECT * FROM `reservations` WHERE `client_id`='$clinet_id' ORDER BY `id` DESC");

     $data=array();
     $data_collection=array();

    while ($row = mysqli_fetch_assoc($query)) {
          $id = $row['id'];
          $client_id=$row['client_id'];
          //from clinet_id get the name , email and phone
          $query_client=$connection->query("SELECT * FROM `clients` Where `id`='$client_id' LIMIT 1");
          $client_data=mysqli_fetch_assoc($query_client);
          $client_name=$client_data['name'];
          $client_email=$client_data['email'];
          $client_phone=$client_data['phone'];
          /////////////////////////////////////////////
          $car_id=$row['car_id'];
          //from car id get car name company name model name
          $query_car=$connection->query("SELECT * FROM `cars` Where `id`='$car_id' LIMIT 1");
          $car_data=mysqli_fetch_assoc($query_car);
          $data['car_name']=$car_name=$car_data['name'];
          $data['company_name']=$car_company_name=companiesName($car_data['company_id']);
          $data['car_model_name']=$car_model_name=ModelNameById($car_data['car_model_id']);

        $data['price']=$price = $row['price'];
        $data['price_per_day']=  $price_per_day=$row['price_per_day'];
        $data['driver']=  $driver=$row['driver'];
        $data['driver_additional']=  $driver_additional=$row['driver_additional'];
        $data['recieved_another_place']=  $recieved_another_place = $row['recieved_another_place'];
        $data['detials']=  $detials = $row['detials'];
        $data['status']=  $status = $row['status'];
        $data['total_cost']=  $total_cost = $row['total_cost'];
        $data['date_from']=  $date_from = $row['date_from'];
        $data['date_to']=  $date_to = $row['date_to'];
        $data['number_of_days']=  $number_of_days = $row['number_of_days'];
        $data['created_at']=  $created_at = $row['created_at'];
        if($data['status']==0){$data['status']="pending";}elseif($data['status']==1){$data['status']="accepted";}else{$data['status']="refuesed";}
        $data_collection[]=$data;

}
return $data_collection;

}


function getCarColors($car_id){
  global $con;
  $connection=$con->connect();

  $query_select = $connection->query("SELECT * FROM `car_colors` WHERE `car_id`='$car_id' ");

  $colors=array();
  while ($row=mysqli_fetch_assoc($query_select)) {
     $colors[]=$row['name'] ;
  }
  return $colors;
}


function getCarAdditions($car_id){
  global $con;
  $connection=$con->connect();

  $query_select = $connection->query("SELECT * FROM `car_additions` WHERE `car_id`='$car_id' ORDER BY `id`");
  $data=array();
  $x=0;
   while ($row=mysqli_fetch_array($query_select)) {
      $data[$x]['name']=$row['name'];
      $data[$x]['price']=$row['price'];
      $x++;
   }
  return $data;
}



function getCarImages($car_id){
  global $con;
  $connection=$con->connect();

  $query_select = $connection->query("SELECT * FROM `car_images` WHERE `car_id`='$car_id' ORDER BY `id`");
  $row_select = mysqli_fetch_array($query_select);
  $x=0;
  $data=array();
  $path='';
   while ($row=mysqli_fetch_array($query_select)){
      $data[$x]['name']=$row['name'];
      $data[$x]['path']="http://www.crt4rent.com/system/api/uploads/car/".$car_id."/".$row['name'];
      $x++;
   }
  return $data;
}

function view_car_ByID($car_id){
  global $con;
  $connection=$con->connect();
  $query = $connection->query("SELECT * FROM `cars` WHERE `id`='$car_id'  ORDER BY `id` DESC");
  $data=array();
  $data_collection=array();
  while ($row = mysqli_fetch_assoc($query)) {
      $data['id']=$id = $row['id'];
      $data['companiy_name']=$company_name=companiesName($row['company_id']);
      $data['car_name']=$name = $row['name'];
      $data['model_name']=  $model_name=ModelNameById($row['car_model_id']);
      $data['model']=$model_tag=$row['model'];
      $data['price']=  $price = $row['price'];
      $data['price']=$price = $row['price'];
      $data['price_per_day']=  $price_per_day=$row['price_per_day'];
      $data['driver']=  $driver=$row['driver'];
      $data['driver_additional']=  $driver_additional=$row['driver_additional'];
      $data['recieved_another_place']=  $recieved_another_place = $row['recieved_another_place'];
      $data['colors']=getCarColors($id);
      $data['additions']=getCarAdditions($id);
      $data['images']=getCarImages($id);
      $data_collection[]=$data;


  }

  return $data_collection;


}


function view_cars($company_id,$model_id) {

    global $con;
    $connection=$con->connect();
    $query = $connection->query("SELECT * FROM `cars` WHERE `company_id`='$company_id' AND `car_model_id`='$model_id' ORDER BY `id` DESC");
    $data=array();
    $data_collection=array();
    while ($row = mysqli_fetch_assoc($query)) {
        $data['id']=$id = $row['id'];
        $data['companiy_name']=$company_name=companiesName($company_id);
        $data['car_name']=$name = $row['name'];
        $data['model_name']=  $model_name=ModelNameById($model_id);
        $data['model']=$model_tag=$row['model'];
        $data['price']=  $price = $row['price'];
        $data['price']=$price = $row['price'];
        $data['price_per_day']=  $price_per_day=$row['price_per_day'];
        $data['driver']=  $driver=$row['driver'];
        $data['driver_additional']=  $driver_additional=$row['driver_additional'];
        $data['recieved_another_place']=  $recieved_another_place = $row['recieved_another_place'];
        $data['colors']=getCarColors($id);
        $data['additions']=getCarAdditions($id);
        $data['images']=getCarImages($id);
        $data_collection[]=$data;


    }

    return $data_collection;
}

function check_email_client($email) {
    global $con;
    $connection=$con->connect();
    $query_select = $connection->query("SELECT * FROM `clients` WHERE `email`='$email'  LIMIT 1 ");
    $data = mysqli_num_rows($query_select);
    return $data;
}


function check_email_mandoob($email) {
    global $con;
    $connection=$con->connect();
    $query_select = $connection->query("SELECT * FROM `mandoobs` WHERE `email`='$email'  LIMIT 1 ");
    $data = mysqli_num_rows($query_select);
    return $data;
}


function check_phone_mandoob($phone) {
    global $con;
    $connection=$con->connect();
    $query_select = $connection->query("SELECT * FROM `mandoobs` WHERE `phone`='$phone'  LIMIT 1 ");
    $data = mysqli_num_rows($query_select);
    return $data?:0;
}

function get_mandoob_data($mandoob_id){
    
    
     global $con;
    $connection=$con->connect();
    $query_select = $connection->query("SELECT * FROM `mandoobs` WHERE `id`='$mandoob_id'  LIMIT 1 ");
    $data = mysqli_fetch_assoc($query_select);
    return $data?$data:(object)array();
    
    
    
}


function check_email_client_edit($email,$client_id) {
    global $con;
    $connection=$con->connect();
    $query_select = $connection->query("SELECT * FROM `clients` WHERE `email`='$email' ORDER BY `id` LIMIT 1 ");
    if(mysqli_num_rows($query_select)){
        $data = mysqli_fetch_assoc($query_select);
        if($data['id']==$client_id){
          $case=1;
        }else{
          $case=0;
        }

    }else{
        $case=1;
    }
    return $case;
}

function check_email_mandoob_edit($email,$mandoob_id) {
    global $con;
    $connection=$con->connect();
    $query_select = $connection->query("SELECT * FROM `mandoobs` WHERE `email`='$email' ORDER BY `id` LIMIT 1 ");
    if(mysqli_num_rows($query_select)){
        $data = mysqli_fetch_assoc($query_select);
        if($data['id']==$mandoob_id){
          $case=1;
        }else{
          $case=0;
        }

    }else{
        $case=1;
    }
    return $case;
}





function add_client($name, $password, $email, $phone,$photo_name) {

    global $con;
    $connection=$con->connect();
    $connection->query("INSERT INTO `clients`(`name`, `email`, `phone`,`password`) VALUES ('$name','$email','$phone','$password')");

    return mysqli_insert_id($connection);
}


function add_mandoob($name, $password, $email, $phone,$photo_name,$type) {

    global $con;
    $connection=$con->connect();
    $connection->query("INSERT INTO `mandoobs`(`name`, `email`, `phone`,`password`,`type`) VALUES ('$name','$email','$phone','$password','$type')");

    return mysqli_insert_id($connection);
}

function get_mandoob_by_id($mandoob_id){
    
    global $con;
    $connection=$con->connect();
    $query= $connection->query("SELECT * FROM `mandoobs` WHERE `id`='$mandoob_id' LIMIT 1 ");
    $data=mysqli_fetch_assoc($query);

    return $data;
}

function add_comment($content,$name){


      global $con;
      $connection=$con->connect();
      $connection->query("INSERT INTO `comments` (`id`, `name`, `content`)  VALUES (null,'$name','$content')");

      return mysqli_insert_id($connection);


}


function check_token($device_token, $client_id,$type) {
    global $con;
    $connection=$con->connect();
    // $devicesArray = "SELECT device_token.*,devices.* from `device_token` left join devices on devices.device_token_id =device_token.id  WHERE device_token.device_token='$device_token' and devices.client_id='{$client_id}'";
    // $query_devicesArray = $connection->query($devicesArray);

    // $check_token=mysqli_num_rows($query_devicesArray);
    // if ($check_token > 0) {
       
    //   $devicesArray = "SELECT device_token.id as device_token_id  from `device_token` left join devices on devices.device_token_id =device_token.id  WHERE device_token.device_token='$device_token' and devices.client_id='{$client_id}'";
    //   $query_devicesArray =$connection->query($devicesArray);
    //   $query_result=mysqli_fetch_array($query_devicesArray);
    //   $device_token_id = $query_result['device_token_id'];
    //   $result_zero = $connection->query("UPDATE devices SET `login`='1',`date_added`='" . date("Y-m-d H:i:s") . "' WHERE `device_token_id`='$device_token_id' and `client_id`='$client_id'");
   
        
    // } else {
  $query_delete=$connection->query("DELETE FROM `devices` WHERE `client_id`='$client_id'");
   $result_one = $connection->query("INSERT INTO device_token(device_token,type,date_added)
                                                       VALUES('$device_token','$type','" . date("Y-m-d H:i:s") . "')
                 ");
   $device_token_id = mysqli_insert_id($connection);
   $result_two = $connection->query("INSERT INTO devices(device_token_id,client_id,login,date_added)
                VALUES('$device_token_id','$client_id','1','" . date("Y-m-d H:i:s") . "')");
//  }

     $connection->query("DELETE FROM `devices` WHERE `device_token_id`=0");
    return mysqli_num_rows($query_devicesArray);
}









function check_token_mandoob($device_token, $mandoob_id,$type) {
    global $con;
    $connection=$con->connect();
//     $devicesArray = " SELECT device_token.*,devices.* from `device_token` left join devices on devices.device_token_id =device_token.id  WHERE device_token.device_token='$device_token' and devices.mandoob_id='{$mandoob_id}'";
//     $query_devicesArray = $connection->query($devicesArray);

//     $check_token=mysqli_num_rows($query_devicesArray);
//     if ($check_token > 0) {
       
//       $devicesArray = "SELECT device_token.id as device_token_id  from `device_token` left join devices on devices.device_token_id =device_token.id  WHERE device_token.device_token='$device_token' and devices.mandoob_id='{$mandoob_id}'";
//       $query_devicesArray =$connection->query($devicesArray);
//       $query_result=mysqli_fetch_array($query_devicesArray);
//       $device_token_id = $query_result['device_token_id'];

//       $result_zero = $connection->query("UPDATE devices SET `login`='1',`date_added`='" . date("Y-m-d H:i:s") . "' WHERE `device_token_id`='$device_token_id' and `mandoob_id`='$mandoob_id'");
//   } else {
   $query_delete=$connection->query("DELETE FROM `devices` WHERE `mandoob_id`='$mandoob_id'");
  
   $result_one = $connection->query("INSERT INTO device_token(device_token,type,date_added)
                 VALUES('$device_token','$type','" . date("Y-m-d H:i:s") . "')");
   $device_token_id = mysqli_insert_id($connection);
   $result_two = $connection->query("INSERT INTO devices(device_token_id,mandoob_id,login,date_added)
                VALUES('$device_token_id','$mandoob_id','1','" . date("Y-m-d H:i:s") . "')");
//  }
    $connection->query("DELETE FROM `devices` WHERE `device_token_id`=0");
    return mysqli_num_rows($query_devicesArray);

    
}



function get_region_id($client_id, $client_address_id) {

    $result = mysql_query("SELECT * FROM `client_addresses` WHERE `client_address_id`='$client_address_id' and `client_id`='$client_id' ORDER BY `client_address_id` DESC") or die(mysql_error());

    $row = mysql_fetch_array($result);

    $region = $row['region'];

    return $region;
}

function get_charge($region_id) {

    $result = mysql_query("SELECT * FROM `regions` WHERE `region_id`='$region_id'  ORDER BY `region_id` DESC") or die(mysql_error());

    $row = mysql_fetch_array($result);

    $charge = $row['charge'];

    return $charge;
}

function get_region_name($region_id) {
     global $con;
    $connection=$con->connect();
    $result =  $connection->query("SELECT * FROM `regions` WHERE `region_id`='$region_id'  ORDER BY `region_id` DESC") or die(mysql_error());

    $row = mysqli_fetch_array($result);

    $region_name_ar = $row['region_name_ar'];

    return $region_name_ar;
}

function get_region_name_en($region_id) {

     global $con;
    $connection=$con->connect();
    $result =  $connection->query("SELECT * FROM `regions` WHERE `region_id`='$region_id'  ORDER BY `region_id` DESC") or die(mysql_error());

    $row = mysql_fetch_array($result);

    $region_name_en = $row['region_name_en'];

    return $region_name_en;
}

function get_client_name_from_id($client_id) {

  global $con;
    $connection=$con->connect();
    $result =  $connection->query("SELECT * FROM `clients` WHERE `id`='$client_id' ORDER BY `id` DESC") or die(mysql_error());

    $row = mysqli_fetch_array($result);

    $client_name = $row['name'];

    return $client_name;
}



function get_client_phone_from_id($client_id) {

    global $con;
    $connection=$con->connect();
    $result =  $connection->query("SELECT * FROM `clients` WHERE `id`='$client_id' ORDER BY `id` DESC") or die(mysql_error());

    $row = mysqli_fetch_array($result);

    $client_name = $row['phone'];

    return $client_name;
}


function check_phone_exist_client($phone){
    
    global $con;

    $connection=$con->connect();
    
    $result =  $connection->query("SELECT * FROM `clients` WHERE `phone`='$phone' LIMIT 1 ") or die(mysql_error());

    $row = mysqli_fetch_array($result);

    $data = $row['id'];

    return $data?:"0";
    
}

function get_questions($lang){
    
    global $con;

    $connection=$con->connect();
     arabic_solve($connection);
    $result =  $connection->query("SELECT * FROM `questions`   ") or die(mysql_error());

    $data=array();
    
    while($row = mysqli_fetch_assoc($result)){
        
        if($lang!="ar"){
            $row["name"]=$row["name_en"];    
        }
        
        unset($row["name_en"]);
        
        $data[]=$row;    
    }

    

    return $data;
    
    
    
    
    
}




function check_phone_exist_mandoob($phone){
    
    
    global $con;

    $connection=$con->connect();

    $result =  $connection->query("SELECT * FROM `mandoobs` WHERE `phone`='$phone' LIMIT 1 ") or die(mysql_error());

    $row = mysqli_fetch_array($result);

    $data = $row['id'];

    return $data?:"0";
    
}


// function get_client_phone_from_id($client_id) {

//     global $con;
//     $connection=$con->connect();
//     $result =  $connection->query("SELECT * FROM `clients` WHERE `client_id`='$client_id' ORDER BY `client_id` DESC") or die(mysql_error());

//     $row = mysql_fetch_array($result);

//     $client_phone = $row['client_phone'];

//     return $client_phone;
// }

?>
