<?php

/*
 * Following code will list all the products
 */
// array for JSON response
$response = array();

// include db connect class
include("db_connect.php");

// connecting to db
$con = new DB_CONNECT();
$connection=$con->connect();

$connection->query("SET NAMES 'utf8'");

$connection->query("SET CHARACTER SET utf8");

$connection->query("SET SESSION collation_connection = 'utf8_unicode_ci'");

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET,POST,PUT,DELETE,OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

$required_parametrs=array("lang","phone","type");
//type=1 client or =2=>mandoob
$errors=array();


$postdata = file_get_contents("php://input");
$Req = json_decode($postdata, TRUE);


foreach ($Req as $key => $value) {
   if(in_array($key,$required_parametrs)){
     $key = array_search($key, $required_parametrs);
     unset($required_parametrs[$key]);

   }else{
     $errors[]="Parameter field is required:";
   }
}
$lang=$Req['lang'];

if(count($required_parametrs)>0){
  //some parameters required
  $response["success"] = 0;
  if ($lang == "ar") {
      $response["message"] = "هناك بيانات مفقوده برجاء مراجعة بياناتك";
  } else {
      $response["required_parameters"] ="error in inputs";
  }

$response["required_parametrs"] = $required_parametrs;

}else{

    $lang=mysqli_real_escape_string($connection, trim($Req['lang']));
    
    $phone=mysqli_real_escape_string($connection, trim($Req['phone']));
    
   $type=mysqli_real_escape_string($connection, trim($Req['type']));
    
    
    if($type==1){
        
        $check_phone=check_phone_exist_client($phone); //client_id returend value 
        
        if($check_phone){
            $check_phone=check_phone_exist_mandoob($phone);
        }
        
    }else if($type==2){
        
        $check_phone=check_phone_exist_mandoob($phone); //mandoob id  returend value 
        
        if($check_phone){
            $check_phone=check_phone_exist_client($phone); //mandoob id  returend value
        }
           
    }else{
        
      $response["success"] = 0;
      
      echo json_encode($response,JSON_UNESCAPED_UNICODE); 
      
      exit;
      
    }
    
    
                    
    
   if( $check_phone ){
      
        $response["success"] = 1;

        if($lang=="ar"){
             $response["message"] ="الرقم موجود";
        }else{
             $response["message"] ="phone number Found";
        }   
        
        $response["client_id"] =$check_phone;
        
   }else{
         $response["success"] = 0;
        
        if($lang=="ar"){
         $response["message"] ="هذا الرقم غير موجود";
        }else{
         $response["message"] ="phone number dose not exist";
        }   
       
   }
   
    
}

  echo json_encode($response,JSON_UNESCAPED_UNICODE);
?>
