<?php

/*
 * Following code will list all the products
 */
// array for JSON response
$response = array();

// include db connect class
include("db_connect.php");

// connecting to db
$con = new DB_CONNECT();
$connection=$con->connect();

$connection->query("SET NAMES 'utf8'");

$connection->query("SET CHARACTER SET utf8");

$connection->query("SET SESSION collation_connection = 'utf8_unicode_ci'");

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET,POST,PUT,DELETE,OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

$required_parametrs=array("longitude","lat","region","client_id","type","lang");
$errors=array();
//,"block","road","building","flat_number","client_phone","delivery_instructions"

$postdata = file_get_contents("php://input");
$Req = json_decode($postdata, TRUE);

foreach ($Req as $key => $value) {
   if(in_array($key,$required_parametrs)){
     $key = array_search($key, $required_parametrs);
     unset($required_parametrs[$key]);

   }else{
     $errors[]="Parameter field is required:";
   }
}

$language=$Req['lang'];

if(count($required_parametrs)>0){
  //some parameters required
  $response["success"] = 0;
  if ($language == "ar") {
      $response["message"] = "هناك بيانات مفقوده برجاء مراجعة بياناتك";
  } else {
      $response["message"] = $errors[0];
  }

}else{
     

    $lat = trim($Req['lat']);
    $lang = trim($Req['longitude']);
    $region = trim($Req['region'])?:0;
    $block = trim($Req['block'])?:" ";
    $road = trim($Req['road'])?:" ";
    $building = trim($Req['building'])?:" ";
    $flat_number = trim($Req['flat_number'])?:" ";
    $client_phone = trim($Req['client_phone'])?: " ";
    $delivery_instructions = trim($Req['delivery_instructions'])?:" ";
    $client_id = trim($Req['client_id']);
    $type=trim($Req['type']);

    $result = $connection->query("INSERT INTO `pickup_destinations`(`mobile`, `region`, `block`, `road`, `building`, `flat_number`, `lat`, `lang`, `type`, `client_id`, `delivery_instructions`)
                                                     VALUES ('$client_phone','$region','$block','$road','$building','$flat_number','$lat','$lang','$type','$client_id','$delivery_instructions')
                         ");
   $error=mysqli_error($connection);
    $response["product"] = array();

    // temp user array
    $product = array();
    $product["id"] = mysqli_insert_id($connection);
    $product["lat"] = $Req["lat"];
    $product["lang"] = $Req["longitude"];
    $product["region_id"] = $Req["region_id"];

    $region_id = $Req["region_id"];
  


    $product["block"] = $Req["block"];
    $product["road"] = $Req["road"];
    $product["building"] = $Req["building"];
    $product["flat_number"] = $Req["flat_number"];
    $product["client_phone"] = $Req["client_phone"];
    $product["note"] = $Req["delivery_instructions"];
    $product["client_id"] = $Req["client_id"];

    // push single product into final response array
    array_push($response["product"], $product);


    // check if row inserted or not
    if ($result) {
        // successfully inserted into database
        $response["success"] = 1;
          if ($language == "ar"){
             $response["message"] = "تم إضافة العنوان بنجاح.";
          }else{
             $response["message"] = "Address Added successfully";
          }
       

    } else {
        // failed to insert row
        $response["success"] = 0;
          if ($language == "ar"){
             $response["message"] = "عفوا لقد حدث خطأ.";
          }else{
             $response["message"] = "There is a Probelem";
          }
       
        $response["message"]=$error;    

        
      
    }
    
}


  echo json_encode($response);

?>