<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/monitoring/v3/notification.proto

namespace Google\Cloud\Monitoring\V3;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A `NotificationChannel` is a medium through which an alert is
 * delivered when a policy violation is detected. Examples of channels
 * include email, SMS, and third-party messaging applications. Fields
 * containing sensitive information like authentication tokens or
 * contact info are only partially populated on retrieval.
 *
 * Generated from protobuf message <code>google.monitoring.v3.NotificationChannel</code>
 */
class NotificationChannel extends \Google\Protobuf\Internal\Message
{
    /**
     * The type of the notification channel. This field matches the
     * value of the [NotificationChannelDescriptor.type][google.monitoring.v3.NotificationChannelDescriptor.type] field.
     *
     * Generated from protobuf field <code>string type = 1;</code>
     */
    private $type = '';
    /**
     * The full REST resource name for this channel. The syntax is:
     *     projects/[PROJECT_ID]/notificationChannels/[CHANNEL_ID]
     * The `[CHANNEL_ID]` is automatically assigned by the server on creation.
     *
     * Generated from protobuf field <code>string name = 6;</code>
     */
    private $name = '';
    /**
     * An optional human-readable name for this notification channel. It is
     * recommended that you specify a non-empty and unique name in order to
     * make it easier to identify the channels in your project, though this is
     * not enforced. The display name is limited to 512 Unicode characters.
     *
     * Generated from protobuf field <code>string display_name = 3;</code>
     */
    private $display_name = '';
    /**
     * An optional human-readable description of this notification channel. This
     * description may provide additional details, beyond the display
     * name, for the channel. This may not exceed 1024 Unicode characters.
     *
     * Generated from protobuf field <code>string description = 4;</code>
     */
    private $description = '';
    /**
     * Configuration fields that define the channel and its behavior. The
     * permissible and required labels are specified in the
     * [NotificationChannelDescriptor.labels][google.monitoring.v3.NotificationChannelDescriptor.labels] of the
     * `NotificationChannelDescriptor` corresponding to the `type` field.
     *
     * Generated from protobuf field <code>map<string, string> labels = 5;</code>
     */
    private $labels;
    /**
     * User-supplied key/value data that does not need to conform to
     * the corresponding `NotificationChannelDescriptor`'s schema, unlike
     * the `labels` field. This field is intended to be used for organizing
     * and identifying the `NotificationChannel` objects.
     * The field can contain up to 64 entries. Each key and value is limited to
     * 63 Unicode characters or 128 bytes, whichever is smaller. Labels and
     * values can contain only lowercase letters, numerals, underscores, and
     * dashes. Keys must begin with a letter.
     *
     * Generated from protobuf field <code>map<string, string> user_labels = 8;</code>
     */
    private $user_labels;
    /**
     * Indicates whether this channel has been verified or not. On a
     * [`ListNotificationChannels`][google.monitoring.v3.NotificationChannelService.ListNotificationChannels]
     * or
     * [`GetNotificationChannel`][google.monitoring.v3.NotificationChannelService.GetNotificationChannel]
     * operation, this field is expected to be populated.
     * If the value is `UNVERIFIED`, then it indicates that the channel is
     * non-functioning (it both requires verification and lacks verification);
     * otherwise, it is assumed that the channel works.
     * If the channel is neither `VERIFIED` nor `UNVERIFIED`, it implies that
     * the channel is of a type that does not require verification or that
     * this specific channel has been exempted from verification because it was
     * created prior to verification being required for channels of this type.
     * This field cannot be modified using a standard
     * [`UpdateNotificationChannel`][google.monitoring.v3.NotificationChannelService.UpdateNotificationChannel]
     * operation. To change the value of this field, you must call
     * [`VerifyNotificationChannel`][google.monitoring.v3.NotificationChannelService.VerifyNotificationChannel].
     *
     * Generated from protobuf field <code>.google.monitoring.v3.NotificationChannel.VerificationStatus verification_status = 9;</code>
     */
    private $verification_status = 0;
    /**
     * Whether notifications are forwarded to the described channel. This makes
     * it possible to disable delivery of notifications to a particular channel
     * without removing the channel from all alerting policies that reference
     * the channel. This is a more convenient approach when the change is
     * temporary and you want to receive notifications from the same set
     * of alerting policies on the channel at some point in the future.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue enabled = 11;</code>
     */
    private $enabled = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $type
     *           The type of the notification channel. This field matches the
     *           value of the [NotificationChannelDescriptor.type][google.monitoring.v3.NotificationChannelDescriptor.type] field.
     *     @type string $name
     *           The full REST resource name for this channel. The syntax is:
     *               projects/[PROJECT_ID]/notificationChannels/[CHANNEL_ID]
     *           The `[CHANNEL_ID]` is automatically assigned by the server on creation.
     *     @type string $display_name
     *           An optional human-readable name for this notification channel. It is
     *           recommended that you specify a non-empty and unique name in order to
     *           make it easier to identify the channels in your project, though this is
     *           not enforced. The display name is limited to 512 Unicode characters.
     *     @type string $description
     *           An optional human-readable description of this notification channel. This
     *           description may provide additional details, beyond the display
     *           name, for the channel. This may not exceed 1024 Unicode characters.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Configuration fields that define the channel and its behavior. The
     *           permissible and required labels are specified in the
     *           [NotificationChannelDescriptor.labels][google.monitoring.v3.NotificationChannelDescriptor.labels] of the
     *           `NotificationChannelDescriptor` corresponding to the `type` field.
     *     @type array|\Google\Protobuf\Internal\MapField $user_labels
     *           User-supplied key/value data that does not need to conform to
     *           the corresponding `NotificationChannelDescriptor`'s schema, unlike
     *           the `labels` field. This field is intended to be used for organizing
     *           and identifying the `NotificationChannel` objects.
     *           The field can contain up to 64 entries. Each key and value is limited to
     *           63 Unicode characters or 128 bytes, whichever is smaller. Labels and
     *           values can contain only lowercase letters, numerals, underscores, and
     *           dashes. Keys must begin with a letter.
     *     @type int $verification_status
     *           Indicates whether this channel has been verified or not. On a
     *           [`ListNotificationChannels`][google.monitoring.v3.NotificationChannelService.ListNotificationChannels]
     *           or
     *           [`GetNotificationChannel`][google.monitoring.v3.NotificationChannelService.GetNotificationChannel]
     *           operation, this field is expected to be populated.
     *           If the value is `UNVERIFIED`, then it indicates that the channel is
     *           non-functioning (it both requires verification and lacks verification);
     *           otherwise, it is assumed that the channel works.
     *           If the channel is neither `VERIFIED` nor `UNVERIFIED`, it implies that
     *           the channel is of a type that does not require verification or that
     *           this specific channel has been exempted from verification because it was
     *           created prior to verification being required for channels of this type.
     *           This field cannot be modified using a standard
     *           [`UpdateNotificationChannel`][google.monitoring.v3.NotificationChannelService.UpdateNotificationChannel]
     *           operation. To change the value of this field, you must call
     *           [`VerifyNotificationChannel`][google.monitoring.v3.NotificationChannelService.VerifyNotificationChannel].
     *     @type \Google\Protobuf\BoolValue $enabled
     *           Whether notifications are forwarded to the described channel. This makes
     *           it possible to disable delivery of notifications to a particular channel
     *           without removing the channel from all alerting policies that reference
     *           the channel. This is a more convenient approach when the change is
     *           temporary and you want to receive notifications from the same set
     *           of alerting policies on the channel at some point in the future.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Monitoring\V3\Notification::initOnce();
        parent::__construct($data);
    }

    /**
     * The type of the notification channel. This field matches the
     * value of the [NotificationChannelDescriptor.type][google.monitoring.v3.NotificationChannelDescriptor.type] field.
     *
     * Generated from protobuf field <code>string type = 1;</code>
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * The type of the notification channel. This field matches the
     * value of the [NotificationChannelDescriptor.type][google.monitoring.v3.NotificationChannelDescriptor.type] field.
     *
     * Generated from protobuf field <code>string type = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setType($var)
    {
        GPBUtil::checkString($var, True);
        $this->type = $var;

        return $this;
    }

    /**
     * The full REST resource name for this channel. The syntax is:
     *     projects/[PROJECT_ID]/notificationChannels/[CHANNEL_ID]
     * The `[CHANNEL_ID]` is automatically assigned by the server on creation.
     *
     * Generated from protobuf field <code>string name = 6;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * The full REST resource name for this channel. The syntax is:
     *     projects/[PROJECT_ID]/notificationChannels/[CHANNEL_ID]
     * The `[CHANNEL_ID]` is automatically assigned by the server on creation.
     *
     * Generated from protobuf field <code>string name = 6;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * An optional human-readable name for this notification channel. It is
     * recommended that you specify a non-empty and unique name in order to
     * make it easier to identify the channels in your project, though this is
     * not enforced. The display name is limited to 512 Unicode characters.
     *
     * Generated from protobuf field <code>string display_name = 3;</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * An optional human-readable name for this notification channel. It is
     * recommended that you specify a non-empty and unique name in order to
     * make it easier to identify the channels in your project, though this is
     * not enforced. The display name is limited to 512 Unicode characters.
     *
     * Generated from protobuf field <code>string display_name = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * An optional human-readable description of this notification channel. This
     * description may provide additional details, beyond the display
     * name, for the channel. This may not exceed 1024 Unicode characters.
     *
     * Generated from protobuf field <code>string description = 4;</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * An optional human-readable description of this notification channel. This
     * description may provide additional details, beyond the display
     * name, for the channel. This may not exceed 1024 Unicode characters.
     *
     * Generated from protobuf field <code>string description = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Configuration fields that define the channel and its behavior. The
     * permissible and required labels are specified in the
     * [NotificationChannelDescriptor.labels][google.monitoring.v3.NotificationChannelDescriptor.labels] of the
     * `NotificationChannelDescriptor` corresponding to the `type` field.
     *
     * Generated from protobuf field <code>map<string, string> labels = 5;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Configuration fields that define the channel and its behavior. The
     * permissible and required labels are specified in the
     * [NotificationChannelDescriptor.labels][google.monitoring.v3.NotificationChannelDescriptor.labels] of the
     * `NotificationChannelDescriptor` corresponding to the `type` field.
     *
     * Generated from protobuf field <code>map<string, string> labels = 5;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * User-supplied key/value data that does not need to conform to
     * the corresponding `NotificationChannelDescriptor`'s schema, unlike
     * the `labels` field. This field is intended to be used for organizing
     * and identifying the `NotificationChannel` objects.
     * The field can contain up to 64 entries. Each key and value is limited to
     * 63 Unicode characters or 128 bytes, whichever is smaller. Labels and
     * values can contain only lowercase letters, numerals, underscores, and
     * dashes. Keys must begin with a letter.
     *
     * Generated from protobuf field <code>map<string, string> user_labels = 8;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getUserLabels()
    {
        return $this->user_labels;
    }

    /**
     * User-supplied key/value data that does not need to conform to
     * the corresponding `NotificationChannelDescriptor`'s schema, unlike
     * the `labels` field. This field is intended to be used for organizing
     * and identifying the `NotificationChannel` objects.
     * The field can contain up to 64 entries. Each key and value is limited to
     * 63 Unicode characters or 128 bytes, whichever is smaller. Labels and
     * values can contain only lowercase letters, numerals, underscores, and
     * dashes. Keys must begin with a letter.
     *
     * Generated from protobuf field <code>map<string, string> user_labels = 8;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setUserLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->user_labels = $arr;

        return $this;
    }

    /**
     * Indicates whether this channel has been verified or not. On a
     * [`ListNotificationChannels`][google.monitoring.v3.NotificationChannelService.ListNotificationChannels]
     * or
     * [`GetNotificationChannel`][google.monitoring.v3.NotificationChannelService.GetNotificationChannel]
     * operation, this field is expected to be populated.
     * If the value is `UNVERIFIED`, then it indicates that the channel is
     * non-functioning (it both requires verification and lacks verification);
     * otherwise, it is assumed that the channel works.
     * If the channel is neither `VERIFIED` nor `UNVERIFIED`, it implies that
     * the channel is of a type that does not require verification or that
     * this specific channel has been exempted from verification because it was
     * created prior to verification being required for channels of this type.
     * This field cannot be modified using a standard
     * [`UpdateNotificationChannel`][google.monitoring.v3.NotificationChannelService.UpdateNotificationChannel]
     * operation. To change the value of this field, you must call
     * [`VerifyNotificationChannel`][google.monitoring.v3.NotificationChannelService.VerifyNotificationChannel].
     *
     * Generated from protobuf field <code>.google.monitoring.v3.NotificationChannel.VerificationStatus verification_status = 9;</code>
     * @return int
     */
    public function getVerificationStatus()
    {
        return $this->verification_status;
    }

    /**
     * Indicates whether this channel has been verified or not. On a
     * [`ListNotificationChannels`][google.monitoring.v3.NotificationChannelService.ListNotificationChannels]
     * or
     * [`GetNotificationChannel`][google.monitoring.v3.NotificationChannelService.GetNotificationChannel]
     * operation, this field is expected to be populated.
     * If the value is `UNVERIFIED`, then it indicates that the channel is
     * non-functioning (it both requires verification and lacks verification);
     * otherwise, it is assumed that the channel works.
     * If the channel is neither `VERIFIED` nor `UNVERIFIED`, it implies that
     * the channel is of a type that does not require verification or that
     * this specific channel has been exempted from verification because it was
     * created prior to verification being required for channels of this type.
     * This field cannot be modified using a standard
     * [`UpdateNotificationChannel`][google.monitoring.v3.NotificationChannelService.UpdateNotificationChannel]
     * operation. To change the value of this field, you must call
     * [`VerifyNotificationChannel`][google.monitoring.v3.NotificationChannelService.VerifyNotificationChannel].
     *
     * Generated from protobuf field <code>.google.monitoring.v3.NotificationChannel.VerificationStatus verification_status = 9;</code>
     * @param int $var
     * @return $this
     */
    public function setVerificationStatus($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Monitoring\V3\NotificationChannel_VerificationStatus::class);
        $this->verification_status = $var;

        return $this;
    }

    /**
     * Whether notifications are forwarded to the described channel. This makes
     * it possible to disable delivery of notifications to a particular channel
     * without removing the channel from all alerting policies that reference
     * the channel. This is a more convenient approach when the change is
     * temporary and you want to receive notifications from the same set
     * of alerting policies on the channel at some point in the future.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue enabled = 11;</code>
     * @return \Google\Protobuf\BoolValue
     */
    public function getEnabled()
    {
        return $this->enabled;
    }

    /**
     * Returns the unboxed value from <code>getEnabled()</code>

     * Whether notifications are forwarded to the described channel. This makes
     * it possible to disable delivery of notifications to a particular channel
     * without removing the channel from all alerting policies that reference
     * the channel. This is a more convenient approach when the change is
     * temporary and you want to receive notifications from the same set
     * of alerting policies on the channel at some point in the future.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue enabled = 11;</code>
     * @return bool|null
     */
    public function getEnabledValue()
    {
        $wrapper = $this->getEnabled();
        return is_null($wrapper) ? null : $wrapper->getValue();
    }

    /**
     * Whether notifications are forwarded to the described channel. This makes
     * it possible to disable delivery of notifications to a particular channel
     * without removing the channel from all alerting policies that reference
     * the channel. This is a more convenient approach when the change is
     * temporary and you want to receive notifications from the same set
     * of alerting policies on the channel at some point in the future.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue enabled = 11;</code>
     * @param \Google\Protobuf\BoolValue $var
     * @return $this
     */
    public function setEnabled($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\BoolValue::class);
        $this->enabled = $var;

        return $this;
    }

    /**
     * Sets the field by wrapping a primitive type in a Google\Protobuf\BoolValue object.

     * Whether notifications are forwarded to the described channel. This makes
     * it possible to disable delivery of notifications to a particular channel
     * without removing the channel from all alerting policies that reference
     * the channel. This is a more convenient approach when the change is
     * temporary and you want to receive notifications from the same set
     * of alerting policies on the channel at some point in the future.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue enabled = 11;</code>
     * @param bool|null $var
     * @return $this
     */
    public function setEnabledValue($var)
    {
        $wrappedVar = is_null($var) ? null : new \Google\Protobuf\BoolValue(['value' => $var]);
        return $this->setEnabled($wrappedVar);
    }

}

